<?php

namespace App\Helpers;

use Request;
use App\LeadMail;


class EmailLog
{
    public static function addToEmailLog($data, $type = null, $remarks = null)
    {



        try {
            $leadMail = new LeadMail();
            $leadMail->leads_id = $data->has('lead_id') ? $data->get('lead_id') : NULL;
            $leadMail->sales_activity_id = $data->has('sale_id') ? $data->get('sale_id') : NULL;
            $leadMail->proposal_id = $data->has('proposal_id') ? $data->get('proposal_id') : NULL;
            $leadMail->receipt_id = $data->has('receipt_id') ? $data->get('receipt_id') : NULL;
            $leadMail->project_id = $data->has('project_id') ? $data->get('project_id') : NULL;

            $leadMail->name = $data->has('name') ? $data->get('name') : NULL;
            $leadMail->mobile = $data->has('mobile') ? $data->get('mobile') : NULL;




            $leadMail->email = $data->get('to');
            $leadMail->cc_email = $data->has('cc') ? $data->get('cc') : NULL;
            $leadMail->bcc_email = $data->has('bcc') ? $data->get('bcc') : NULL;
            $leadMail->subject = $data->has('subject') ? $data->get('subject') : NULL;
            $leadMail->content = $data->has('message') ? $data->get('message') : NULL;
            $leadMail->send_by = auth()->user()->id;

            $leadMail->mail_type = 'CUSTOM CONTENT';
            if ($data->has('email_type')) {
                $leadMail->mail_type = $data->get('email_type');
            }



            $leadMail->lead_or_crm = $type;
            $leadMail->remarks = $remarks;


            $leadMail->save();
        } catch (\Throwable $th) {

            info($th);
            return false;
            //throw $th;
        }
    }
}
