<?php

namespace App\Helpers;

use App\Lead;
use App\LeadReAllocationLog;
use App\Notifications\AllocationNotification;
use App\Task;
use App\User;
use App\UserSourceCount;
use Illuminate\Support\Facades\DB;
use Request;


class LeadDistributeHelper
{

    public function __construct()
    {
        $allLeads = Lead::query()
            ->select('id', 'source', 'attended_by', 'created_at')
            ->where('is_ceo_verified', 1)
            ->where('sale_status', 'no')
            ->where('show_in_salesperson_actions', 1)
            ->whereNull('attended_by')
            ->get();

        // dd($allLeads->isNotEmpty());

        foreach ($allLeads as $lead) {
            $this->distributeLeads($lead->source, $lead);
        }
    }

    public static function  distributeLeads($source, $lead)
    {
        DB::beginTransaction();
        try {
            $leadObj = Lead::where('id', $lead->id)->first();

            $userSourceCounts = UserSourceCount::query()
                ->where('source_id', $source)
                ->where('is_active', 1)
                ->get();
            $eligibleUser = $userSourceCounts->sortBy('count')->first();
            $allocateTo = $eligibleUser->user_id;


            $check = false;
            $check_email = false;
            $check_mobile_task = false;
            $check_email_task = false;
            $fifteenDays = now()->subDays(15);
            $oneMonthBefore = now()->subMonths(1);

            if (!empty($leadObj->mobile)) {

                $check = Lead::where('mobile', $leadObj->mobile)
                    ->orderBy('created_at', 'desc')
                    ->skip(1)
                    ->take(1)
                    ->first();

                if (!$check) {
                    $mbb = $leadObj->phone_code . $leadObj->mobile;
                    $check = Lead::where('mobile', $mbb)
                        ->orderBy('created_at', 'desc')
                        ->skip(1)
                        ->take(1)
                        ->first();
                    if (!$check) {
                        $check = Lead::where('phone_code', $leadObj->phone_code)
                            ->where('mobile', $leadObj->mobile)
                            ->orderBy('created_at', 'desc')
                            ->skip(1)
                            ->take(1)
                            ->first();

                        if (!$check) {
                            $n = 10;

                            if (strlen($leadObj->mobile) == 9) {
                                $n = 9;
                            }

                            if (strlen($leadObj->mobile) == 8) {
                                $n = 8;
                            }

                            $start = strlen($leadObj->mobile) - $n;
                            $last_str = substr($leadObj->mobile, $start);
                            if ($start >= 0) {
                                $check = Lead::where('mobile', 'LIKE', '%' . $last_str . '%')->orderBy('created_at', 'desc')->skip(1)->take(1)->first();
                            }
                        }
                    }
                }
            }

            if (!empty($leadObj->email)) {
                $check_email = Lead::where('email', $leadObj->email)
                    ->orderBy('created_at', 'desc')
                    ->skip(1)
                    ->take(1)
                    ->first();
            }

            if ($check) {
                $check_mobile_task = Task::where('lead_id', $check->id)->get()->last();
            }

            if ($check_email) {
                $check_email_task = Task::where('lead_id', $check_email->id)->get()->last();
            }

            if ($check && $check->created_at >= $oneMonthBefore && $check->attended_by) {

                $attendedUser = User::where('id', $check->attended_by)
                    ->where('status', 1)->first();

                if ($attendedUser) {
                        $branchHead = User::where('branch_id', $attendedUser->branch_id)->whereHas('roles', function ($q) {
                            $q->where('role_id', 3);
                        })->where('status', 1)->first();
                        $allocateTo = $branchHead->id;
                }

            } elseif ($check_email && $check_email->created_at >= $oneMonthBefore && $check_email->attended_by) {

                $attendedUser = User::where('id', $check_email->attended_by)
                    ->where('status', 1)->first();

                if ($attendedUser) {
                        $branchHead = User::where('branch_id', $attendedUser->branch_id)->whereHas('roles', function ($q) {
                            $q->where('role_id', 3);
                        })->where('status', 1)->first();
                        $allocateTo = $branchHead->id;
                }
            } elseif ($check_mobile_task && $check_mobile_task->created_at >= $fifteenDays) {

                $attendedUser = User::where('id', $check_mobile_task->created_by)
                    ->where('status', 1)
                    ->first();
               if ($attendedUser) {
                        $branchHead = User::where('branch_id', $attendedUser->branch_id)->whereHas('roles', function ($q) {
                            $q->where('role_id', 3);
                        })->where('status', 1)->first();
                        $allocateTo = $branchHead->id;
                }
            } elseif ($check_email_task && $check_email_task->created_at >= $fifteenDays) {



                $attendedUser = User::where('id', $check_email_task->created_by)
                    ->where('status', 1)
                    ->first();
                if ($attendedUser) {
                        $branchHead = User::where('branch_id', $attendedUser->branch_id)->whereHas('roles', function ($q) {
                            $q->where('role_id', 3);
                        })->where('status', 1)->first();
                        $allocateTo = $branchHead->id;
                }
            }
            //  else {

            //     $userSourceCounts = UserSourceCount::query()
            //         ->where('source_id', $source)
            //         ->where('is_active', 1)
            //         ->get();

            //     $eligibleUser = $userSourceCounts->sortBy('count')->first();
            //     $allocateTo = $eligibleUser->user_id;
            // }



            $leadObj->allocation_date = date('Y-m-d');
            $leadObj->attended_by = $allocateTo;


            if ($leadObj->save()) {

                //add-log-to-re-allocation-log-table
                $reAllocationLog = new LeadReAllocationLog();
                $reAllocationLog->lead_id = $leadObj->id;
                $reAllocationLog->allocated_to = $leadObj->attended_by;
                $reAllocationLog->allocation_date = $leadObj->allocation_date;
                $reAllocationLog->log_from='auto_allocation';
                $reAllocationLog->save();

                //Send-Notification-to-App
                $user = User::find($leadObj->attended_by);

                if ($user->push_token != '') {
                    $user->notify(new AllocationNotification($user));
                }

                //Update-User-role-count
                $userSourceCount = UserSourceCount::query()
                    ->where('source_id', $source)
                    ->where('user_id', $allocateTo)->first();

                $userSourceCount->count = $userSourceCount->count + 1;
                $userSourceCount->save();


                // info('lead-allocated with lead ID :' . $leadObj->id . ' allocated to -' . $allocateTo);
                DB::commit();
                return true;
            }
        } catch (\Throwable $th) {
            // info('there is an error for allocate lead ');
            DB::rollBack();
            return false;
        }
    }
}
