<?php

namespace App\Helpers;

use App\Lead;
use App\Notifications\AllocationNotification;
use App\User;
use Illuminate\Support\Facades\DB;
use Request;


class LeadDistributeHelperCopy
{

    public function __construct()
    {


        $allLeads = Lead::query()
            ->select('id', 'source', 'attended_by', 'created_at')
            ->where('is_ceo_verified', 1)
            ->where('sale_status', 'no')
            ->where('show_in_salesperson_actions', 1)
            ->whereNull('attended_by')
            ->get();

        foreach ($allLeads as $lead) {
            $this->distributeLeads($lead->source, $lead);
        }
    }

    public static function  distributeLeads($source, $lead)
    {

        DB::beginTransaction();
        try {
            $teamLeaders = User::with('roles')->whereHas('roles', function ($q) {
                $q->where('role_id', 7);
            })->where('status', 1)->get();

            $teamLeadersIds = $teamLeaders->pluck('id')->toArray();

            $leaders = [];
            foreach ($teamLeaders as $key => $item) {
                $leaders[] = [
                    'user' => $item->id,
                    'total_leads' => 0,
                ];
            }

            $leadersCollection = collect($leaders);

            $leads = Lead::where('source', $source)
                ->whereIn('attended_by', $teamLeadersIds)
                ->where('created_at', '>=', '2023-02-10 00:00:00')
                ->groupBy('attended_by')
                ->selectRaw('attended_by, count(*) as total')
                ->get();


            $leads_by_user = [];
            foreach ($leads as $key => $item) {
                $leads_by_user[] = [
                    'user' => $item->attended_by,
                    'total_leads' => $item->total,
                ];
            }

            $leadsByUserCollection = collect($leads_by_user);

            $mergedCollection = $leadsByUserCollection->merge($leadersCollection)->unique('user');

            $eligibleUser = $mergedCollection->sortBy('total_leads')->first();

            $lead->allocation_date = date('Y-m-d');
            $lead->attended_by = $eligibleUser['user'];

            if ($lead->save()) {
                // $lead->update(['show_in_salesperson_actions' => 0]);
                $user = User::find($lead->attended_by);
                if ($user->push_token != '') {
                    $user->notify(new AllocationNotification($user));
                }
                info('lead-allocated with lead ID :' . $lead->id . ' allocated to -' . $eligibleUser['user']);
                DB::commit();
                return true;
            }
        } catch (\Throwable $th) {
            info('there is an error for allocate lead with ID :' . $lead->id . ' and allocated to -' . $eligibleUser['user']);
            info($th);
            DB::rollBack();
            return false;
        }
        //

        // $lead->update(['attended_by' => $eligibleUser['user']]);
    }
}
