<?php

namespace App\Helpers;

use App\PreferredProject;
use App\PriceList;
use App\Proposal;
use App\ProposalEmi;
use PDF;
use Illuminate\Support\Facades\DB;

class ProposalHelper
{
    public function createProposal($request)
    {
        try {
            $project = PreferredProject::find($request->project_id);
            if ($project->proposal_type == 3) {
                $proposal = new Proposal();
                $proposal->project_id = $request->project_id;
                $proposal->preferred_project = $project->project_name;
                $proposal->project_type = $project->project_type;
                $proposal->pref_name = $request->pref_name;
                $proposal->name = $request->name;
                $proposal->phone = $request->phone;
                $proposal->email = $request->email;
                $proposal->option_1 = $request->option_1;
                $proposal->option_2 = $request->option_2;
                $proposal->option_3 = $request->option_3;
                $proposal->share_price = $project->share_amount;
                $proposal->administration_cost = $project->administration_cost;
                $proposal->project_monthly_return = $project->project_monthly_return;
                $proposal->created_by = auth()->user()->id;
                $proposal->save();

                if ($proposal->project_id == 25 || $proposal->project_id == 26 || $proposal->project_id == 27) {
                    $pdf = \PDF::loadView('dashboard.Retail.retail-mannarkad-pdf', [
                        'proposel' => $proposal,

                        'project' => $project,
                    ]);
                } else {
                    $pdf = \PDF::loadView('dashboard.Retail.retail-pdf', [
                        'proposel' => $proposal,
                        'project' => $project,
                    ]);
                }

                $fileName = 'uploads/proposals/leads/'.$proposal->pref_name.$proposal->name.'_'.$proposal->id.'.pdf';
                $pdf->save($fileName);
                $proposal->file = $fileName;
                $proposal->save();
            }

            return $proposal;
        } catch (\Throwable $th) {
            dd($th);

            return false;
            //throw $th;
        }
    }

    public function createProposalCommercial($request)
    {

        try {
            DB::beginTransaction();
            $project = PreferredProject::find($request->project_id);
            $unit = PriceList::find($request->proposal_unit_id);
            $proposal = new Proposal();
            $proposal->project_id = $request->project_id;
            $proposal->unit_id = $request->proposal_unit_id;
            $proposal->pref_name = $request->pref_name;
            $proposal->name = $request->name;
            $proposal->email = $request->email;
            $proposal->phone = $request->phone;
            $proposal->cess = $request->cess;
            $proposal->valuation_fee = $request->valuation_fee;
            $proposal->registration_expense = $request->registration_expense;
            $proposal->rental_type = $request->type;
             $month = null;
            if($request->type == 'rental_commitment'){
                $rent = $request->sba_area * 30;
                $proposal->monthly_rental = $rent;
            }
            $proposal->apartment_floor = $unit->floor;
            $proposal->preferred_project = $project->project_name;
            $proposal->project_type = $project->project_type;
            $proposal->type_apartment = $request->apartment_type;
            $proposal->no_rooms = $request->no_rooms;
            $proposal->area_apartment = $request->area_apartment;
            $proposal->sba = $request->sba_area;
            $proposal->carpet_area = $request->carpet_area;
            $proposal->sale_value = $request->cost_apartment;
            $proposal->amount_received = $request->amount_received;
            $proposal->grand_total =  $request->grand_total;
            $proposal->rate_per_sqft = $request->association_deposit;
            $proposal->on_booking_grand_total = $request->grand_total * 30 /100;
            $proposal->on_agreement_grand_total =  $request->grand_total * 10 /100;
            if ($request->amount_received) {
                $agreementbalance  =  $request->on_booking_grand_total - $request->amount_received;
                $proposal->balance_agreement = $agreementbalance;
                $proposal->balance =$request->grand_total * 60 /100;
            } else {
                $balance = $request->balance;
            }
            $proposal->balance = $balance;
           

            $proposal->created_by  = auth()->user()->id;
            if ($proposal->save()) {

                $emi = $balance / 3;
                $month = now();
                for ($i = 1; $i <= 3; ++$i) {
                    ProposalEmi::create([
                        'proposal_id' => $proposal->id,
                        'total_amount' =>   $request->grand_total,
                        'balance_amount' => $balance,
                        'emi_amount' => $emi,
                        'date' => $month->addMonth(),
                        'unit_id' => $request->proposal_unit_id,
                        'created_at' => now(),
                    ]);
                }
            }

            $proposalemi = ProposalEmi::where('proposal_id', $proposal->id)->get();

            $pdf = \PDF::loadView('dashboard.Retail.hilite-pdf', [
                'proposel' => $proposal,
                'proposalemi' => $proposalemi,
                'project' => $project,

            ]);

            $fileName = 'uploads/proposals/leads/' . $proposal->pref_name . $proposal->name . '_' . $proposal->id . '.pdf';
            $pdf->save($fileName);
            $proposal->file = $fileName;
            $proposal->save();




            $activity_subject = auth()->user()->name . ' added new proposal with id ' . $proposal->id;
            ActivityLog::addToLog($activity_subject, 'leads');
            DB::commit();

            return true;
        } catch (\Throwable $th) {
            info($th);
            DB::rollback();
            return false;
        }
    }
}
