<?php

namespace App\Helpers;

use App\Lead;
use App\LeadReAllocationLog;
use App\User;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use Request;


class SendLeadsBackToReAllocationHelper
{

    public function __construct()
    {

        $executives = User::whereHas('roles', function ($q) {
            $q->where('role_id', 8);
        })->pluck('id');

        $allocatedLeads = Lead::query()
            ->select('id', 'attended_by', 'allocation_date', 'is_attended', 'is_ceo_verified', 'sale_status', 'show_in_salesperson_actions', 'allocated_by')
            ->where('is_ceo_verified', 1)
            ->where('sale_status', 'no')
            ->whereIn('attended_by', $executives)
            ->whereNotNull('allocation_date')
            ->where('is_attended', 0)
            ->get();
        foreach ($allocatedLeads as $lead) {
            $this->sendBackToAllocation($lead);
        }
    }

    public static function  sendBackToAllocation($lead)
    {
        DB::beginTransaction();
        try {
            $currentDate = Carbon::now();
            $allocatedDate = Carbon::createFromFormat('Y-m-d H:i:s', $lead->allocation_date);
            if ($allocatedDate->addDay()->lt($currentDate) && $allocatedDate >= '2023-06-13 00:00:00') {
                $reAllocationLog = new LeadReAllocationLog();
                $reAllocationLog->lead_id = $lead->id;
                $reAllocationLog->allocated_to = $lead->attended_by;
                $reAllocationLog->allocation_date = $lead->allocation_date;
                $reAllocationLog->allocated_by = $lead->allocated_by;
                $reAllocationLog->log_from='returned_to_allocation';
                $reAllocationLog->save();
                $lead->update(['attended_by' => NULL, 'show_in_salesperson_actions' => 1,'allocated_by'=>NULL,'allocation_date'=>NULL]);
                DB::commit();
                return true;
            }
        } catch (\Throwable $th) {
            DB::rollBack();
            // info($th);
            // info('there is an error for re-allocate lead');
        }
    }
}
