<?php

namespace App\Http\Controllers\Api\V1\Enquiry;

use App\Http\Controllers\Controller;
use App\Http\Requests\Api\Enquiry\EnquiryRequest;
use App\Lead;

class EnquiryController extends Controller
{
    public function store(EnquiryRequest $request)
    {
        $remarks = $request->input('message') . "\n\n";
        $remarks .= "Convenient time to call : " .
            $request->input('convenient_day') . " " . $request->input('convenient_time');

        $data = [
            'enquirer_name' => $request->input('first_name') . " ". $request->input('last_name'),
            'mobile' => $request->input('phone'),
            'source' => '3', // web enquiry
            'email' => $request->input('email'),
            'project_type' => 1,
            'preferred_project' => 1,
            'remarks' => $remarks,
            'lead_date' => now()->format('Y-m-d'),
        ];

        $lead = Lead::create($data);

        if ($lead) {
            return response()->json([
                'success' => true,
                'message' => 'Enquiry successfully submitted',
            ]);
        }

        return response()->json([
            'success' => false,
            'message' => 'Something went wrong! Please try again'
        ]);
    }
}
