<?php

namespace App\Http\Controllers\Auth;

use Carbon\Carbon;
use App\Permission;
use App\LoginTracking;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use App\Providers\RouteServiceProvider;
use Illuminate\Foundation\Auth\AuthenticatesUsers;

class LoginController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Login Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles authenticating users for the application and
    | redirecting them to your home screen. The controller uses a trait
    | to conveniently provide its functionality to your applications.
    |
    */

    use AuthenticatesUsers;

    /**
     * Where to redirect users after login.
     *
     * @var string
     */
    protected $redirectTo = '/';
    //protected $redirectTo = 'dashboard';
    //protected $redirectTo = RouteServiceProvider::HOME;

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest')->except('logout');
    }

    // The below method we add here to login using username instead of email
    public function username()
    {
        return 'username';
    }

    public function authenticated(Request $request, $user)
    {

        $current_user_idd = $user->id;
        date_default_timezone_set('Asia/Kolkata');
        $c_time = date('Y-m-d H:i:s');
        $user->last_login_at = $c_time;
        $user->save();

        // $user->update([
        //    // 'last_login_at' => Carbon::now()->toDateTimeString(),
        //     'last_login_at' => $c_time

        // ]);
        // if (!$user->hasRole('user')) {
        if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
            $ip_address = $_SERVER['HTTP_CLIENT_IP'];
        }
        //whether ip is from proxy
        elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
            $ip_address = $_SERVER['HTTP_X_FORWARDED_FOR'];
        }
        //whether ip is from remote address
        else {
            $ip_address = $_SERVER['REMOTE_ADDR'];
        }

        $obj_tracking = new LoginTracking();
        $obj_tracking->user_id = $current_user_idd;
        $obj_tracking->login_at = $c_time;
        //$obj_tracking->login_at = Carbon::now()->toDateTimeString();
        //$obj_tracking->login_ip = $request->getClientIp();
        $obj_tracking->login_ip = $ip_address;
        $obj_tracking->save();
        //whether ip is from share internet
        // }
        // log Activity
        $activity_subject = $user->name . ' logged in with ID : ' . $user->id;

        \ActivityLog::addToLog($activity_subject, 'login');

        $leadsPermissions = Permission::with('roles')->where('type', 'leads')->pluck('slug')->toArray();
        $crmPermissions = Permission::with('roles')->where('type', 'crm')->pluck('slug')->toArray();


        // if ($user->hasRole('lead-bank')) {
        //     return redirect()->route('leadbank.listing');
        // } else {
        //     if ($user->checkPermissions($leadsPermissions) && $user->checkPermissions($crmPermissions)) {
        //         return redirect()->route('home');
        //     }
        //     if ($user->checkPermissions($crmPermissions)) {
        //         return redirect()->route('crm.dashboard');
        //     }
        //     if ($user->checkPermissions($leadsPermissions)) {
        //         return redirect()->route('dashboard.home');
        //     }
        // }


        if ($user->hasRole('lead-bank')) {
            return redirect()->route('leadbank.listing');
        } elseif ($user->checkPermissions($leadsPermissions) && $user->checkPermissions($crmPermissions)) {

            // $details = 'user id: ' . $user->id . ' | user name : ' . $user->name . ' | Time : ' . now() . ' | leads permission : ' . $user->checkPermissions($leadsPermissions) . ' | crm permission : ' . $user->checkPermissions($crmPermissions);
            // info($details);
            return redirect()->route('home');
        } elseif ($user->checkPermissions($leadsPermissions)) {
            return redirect()->route('dashboard.home');
        } elseif ($user->checkPermissions($crmPermissions)) {
            return redirect()->route('crm.dashboard');
        }
    }

    protected function credentials(Request $request)
    {
        return ['username' => $request->{$this->username()}, 'password' => $request->password, 'status' => 1];
    }
}
