<?php

namespace App\Http\Controllers\Dashboard;

use App\ActivityLog;
use App\Http\Controllers\Controller;
use DataTables;

class ActivityLogController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
        return view('dashboard.activity_logs.index');
    }

    public function list()
    {
        $data = ActivityLog::where('activity_type', 'leads')->orderBy('activity_at', 'desc');

        return DataTables::of($data)
         ->addIndexColumn()
         ->editColumn('user_id', function ($data) {
             $name = isset($data->getUser) ? $data->getUser->name : '';

             return $name;
         })

//          ->addColumn('action', function($data){

//              $btn = "<a class='dropdown-trigger btn' href='#' data-target='dropdownnote".$data->id."'><i class='fa fa-cog'></i></a>";
//              $btn = $btn."<ul id='dropdownnote".$data->id."' class='dropdown-content'>
// <li><a href='javascript:void(0)' class='deleteActivity' data-id='".$data->id."'>Delete</a></li>

// </ul>";

//                  return $btn;
//          })
         ->rawColumns(['action'])
         ->make(true);
    }

    public function lastActivity()
    {
        return view('dashboard.activity_logs.last-activity');
    }

    public function lastActivityList()
    {
        $data = \App\User::orderBy('id', 'asc');

        return DataTables::of($data)
         ->addIndexColumn()
         ->editColumn('description', function ($data) {
             // dd($data->id);
             //dd($data->getLastActivityLog());
             $desc = $data->getLeadsLastActivityLog() ? $data->getLeadsLastActivityLog()->description : '';

             return $desc;
         })->editColumn('name', function ($data) {
             return $data->name;
         })->editColumn('last_login_at', function ($data) {
             return $data->last_login_at;
         })->editColumn('ip_address', function ($data) {
             $ip = $data->getLeadsLastActivityLog() ? $data->getLeadsLastActivityLog()->ip_address : '';

             return $ip;
         })->editColumn('activity_at', function ($data) {
             $activity_at = $data->getLeadsLastActivityLog() ? $data->getLeadsLastActivityLog()->activity_at : '';

             return $activity_at;
         })

         ->rawColumns(['action'])
         ->make(true);
    }
}
