<?php

namespace App\Http\Controllers\Dashboard;

use App\Lead;
use App\PriceList;
use App\ProjectBlock;
use App\PreferredProject;
use App\Helpers\ActivityLog;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Requests\LeadDelete\DeleteLeadRequest;
use App\Task;

class AjaxController extends Controller
{
    /**
     * Create a new controller instance.

     *

     * @return void
     */
    public function __construct()
    {
        //$this->middleware('auth');
    }

    /**
     * Show the application dashboard.

     *

     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function getPreferredProjects(Request $request)
    {
        $project_type = $request->project_type;

        $r = PreferredProject::where('project_type', $project_type)->where('status', 1)
        ->where('visibility','others')->get();

        return response()->json(['data' => $r, 'status' => 200], 200);

        exit;
    }

    public function deleteLead(Request $request)
    {
        $id = $request->id;

        $row = \App\Lead::find($id);

        // if($row->duplicate_entry=='yes' && $row->sales_head_approval=='0'){

        //     return response()->json(['msg'=>'Failed','status'=>200],200);

        // die;

        // }

        \App\Lead::find($id)->delete();

        \App\LeadAlternativeProject::where('lead_id', $id)->delete();

        // log Activity

        $activity_subject = \Auth::user()->name . ' deleted a lead ' . $row->enquirer_name . ' with ID : ' . $row->id;

        \ActivityLog::addToLog($activity_subject, 'leads');

        return response()->json(['msg' => 'Deleted', 'status' => 200], 200);

        exit;
    }

    public function leadDelete(DeleteLeadRequest $request)
    {
        $id = $request->id;

        $row = \App\Lead::find($id);

        $row->delete_ramarks = $request->delete_remarks;
        $row->save();

        \App\Lead::find($id)->delete();

        \App\LeadAlternativeProject::where('lead_id', $id)->delete();

        // log Activity

        $activity_subject = \Auth::user()->name . ' deleted a lead ' . $row->enquirer_name . ' with ID : ' . $row->id;

        \ActivityLog::addToLog($activity_subject, 'leads');

        return response()->json(['msg' => 'Successfully Deleted', 'status' => 200], 200);

        exit;
    }

    public function approveDuplicateEntry(Request $request)
    {
        $id = $request->id;

        $obj = \App\Lead::find($id);

        $obj->sales_head_approval = 1;

        $obj->save();

        // log Activity

        $activity_subject = \Auth::user()->name . ' approved a duplicate lead ' . $obj->enquirer_name . ' with ID : ' . $obj->id;

        \ActivityLog::addToLog($activity_subject, 'leads');

        return response()->json(['msg' => 'Approved', 'status' => 200], 200);

        exit;
    }

    public function approveLostLead(Request $request)
    {
        $id = $request->id;

        $obj = \App\Lead::find($id);

        $obj->lost_lead_approval = 1;

        $obj->save();

        // log Activity

        $activity_subject = \Auth::user()->name . ' approved a lost lead ' . $obj->enquirer_name . ' with ID : ' . $obj->id;

        \ActivityLog::addToLog($activity_subject, 'leads');

        return response()->json(['msg' => 'Approved', 'status' => 200], 200);

        exit;
    }

    public function editSalesPersonAction(Request $request)
    {
        $id = $request->id;

        $mobile = $request->mobile;

        $phone_code = $request->phone_code;

        if (empty($mobile)) {
            return response()->json(['error' => 'Mobile is required']);

            exit;
        }

        if (empty($phone_code)) {
            return response()->json(['error' => 'Country Code is required']);

            exit;
        }

        $obj = \App\Lead::find($id);

        $check = \App\Lead::where('mobile', $mobile)->where('id', '<>', $id)->first();

        if (!$check) {
            $mbb = $phone_code . $mobile;

            $check = \App\Lead::where('mobile', $mbb)->where('id', '<>', $id)->first();

            if (!$check) {
                $check = \App\Lead::where('phone_code', $phone_code)->where('mobile', $mobile)->where('id', '<>', $id)->first();
            }

            if (!$check) {
                $n = 10;

                $start = strlen($mobile) - $n;

                $last_str = substr($mobile, $start);

                if ($start >= 0) {
                    $check = \App\Lead::where('mobile', 'LIKE', '%' . $last_str . '%')->where('id', '<>', $id)->first();
                }
            }
        }

        $obj->phone_code = $phone_code;

        $obj->mobile = $mobile;

        if ($check) {
            $obj->duplicate_entry = 'yes';

            if ($obj->sales_head_approval != 1) {
                $obj->sales_head_approval = 0;
            }
        } else {
            $obj->duplicate_entry = 'no';

            $obj->sales_head_approval = null;
        }

        $obj->save();

        $activity_subject = auth()->user()->name . ' Updated Sales Person Actions with ID : ' . $obj->id;
        \ActivityLog::addToLog($activity_subject, 'leads');

        return response()->json(['msg' => 'Updated', 'error' => '', 'status' => 200], 200);

        exit;
    }

    public function getLeadEditView(Request $request)
    {
        $id = $request->lead_id;

        $obj = \App\Lead::find($id);

        $mobile = $obj->mobile;

        $phone_code = $obj->phone_code;

        $countries = \App\Country::orderBy('phonecode', 'asc')->get();

        $returnHTML = \View::make('dashboard.leads.ajax-edit-lead-pop')->with(['id' => $id, 'mobile' => $mobile, 'phone_code' => $phone_code, 'countries' => $countries])->render();

        $activity_subject = auth()->user()->name . ' Viewed Lead Edit Form from sales person actions with id : ' . $obj->id;
        ActivityLog::addToLog($activity_subject, 'leads');

        return response()->json(['data' => $returnHTML, 'status' => 200], 200);

        exit;
    }

    public function getTaskEditStatusView(Request $request)
    {
        $id = $request->task_id;

        $obj = \App\Task::find($id);

        $type = $obj->create_task_id;

        $remarks = $obj->remarks_pop;

        if ($type == 1) {
            $statuses = \App\FollowupStatus::where('status', 1)->get();

            $sel = $obj->followup_status;
        } else {
            $statuses = \App\SitevisitStatus::where('status', 1)->get();

            $sel = $obj->sitevisit_status;
        }

        $returnHTML = \View::make('dashboard.leads.ajax-edit-task-status-pop')->with(['id' => $id, 'type' => $type, 'statuses' => $statuses, 'remarks' => $remarks, 'sel' => $sel])->render();

        return response()->json(['data' => $returnHTML, 'status' => 200], 200);

        exit;
    }

    public function updateTaskStatus(Request $request)
    {
        $id = $request->id;

        $status = $request->t_status;

        $remarks = $request->t_remarks;

        $sent_email = $request->sent_email ? $request->sent_email : 0;

        $obj = \App\Task::find($id);

        $lead_det = \App\Lead::find($obj->lead_id);

        if ($obj->create_task_id == 1) {
            $obj->followup_status = $status;
        } else {
            $obj->sitevisit_status = $status;
        }

        $obj->remarks_pop = $remarks;

        $obj->updated_by = \Auth::user()->id;

        $obj->save();

        if ($obj->create_task_id == 2) {
            if ($obj->site_visit_mail_sent != 1 && $sent_email == 1) {
                // $to = $lead_det->email;

                $to = 'rajeesh@meridian.net.in';

                if (!empty($to)) {
                    $details = [
                        'name' => $lead_det->contact_person,
                    ];

                    \Mail::to($to)->send(new \App\Mail\SiteVisitMail($details));
                }
            }
        }

        $activity_subject = auth()->user()->name . ' updated task status with task ID :' . $obj->id . ' and lead ID :' . $lead_det->id;

        ActivityLog::addToLog($activity_subject, 'leads');

        return response()->json(['msg' => 'Updated', 'error' => '', 'status' => 200], 200);

        exit;
    }


    public function getDuplicateLeads(Request $request)
    { // Mobile duplicate
        $lead_id = $request->lead_id;

        $lead_det = \App\Lead::find($lead_id);



        $mb = $lead_det->mobile;

        $phone_code = $lead_det->phone_code;

        $str = '';

        $str1 = '';

        $lp = '';

        $str2 = '';

        // if (empty($lead_det->attended_by)) {

        $dup_leads = \App\Lead::where('mobile', $mb)->where('id', '<>', $lead_id)->get();


        if (isset($dup_leads) && count($dup_leads) > 0) {
        } else {
            $mbb = $phone_code . $mb;

            $dup_leads = \App\Lead::where('mobile', $mbb)->where('id', '<>', $lead_id)->get();




            if (isset($dup_leads) && count($dup_leads) > 0) {
            } else {
                $n = 10;

                $start = strlen($mb) - $n;

                $last_str = substr($mb, $start);

                if ($start >= 0) {
                    $dup_leads = \App\Lead::where('mobile', 'LIKE', '%' . $last_str . '%')->where('id', '<>', $lead_id)->get();

                    // dd($dup_leads);
                }
            }
        }



        if (isset($dup_leads) && count($dup_leads) > 0) {
            $str1 .= '<table>

                       <thead>

                       <th>Enquirer Name</th>

                    <th>Enq Date</th>

                    <th>Stage</th>

                    <th>Source</th>

                    <th>Project</th>

                    <th>Project Type</th>

                    <th>Attended By</th>

                    <th>Mobile</th>

                    <th>Email</th>

                    <th>View</th>

                    </thead><tbody>';

            foreach ($dup_leads as $data) {
                $id = $data->id;

                $attended_by = isset($data->getAttendedBy) ? $data->getAttendedBy->name : '';

                $orgDate = $data->created_at;

                $newDate = date('d-m-Y', strtotime($orgDate));

                $lead_stage = isset($data->getLeadStage) ? $data->getLeadStage->name : '';

                $source = isset($data->getSource) ? $data->getSource->name : '';

                $project_type = isset($data->getProjectType) ? $data->getProjectType->name : '';

                $pref_project = isset($data->getPreferredProject) ? $data->getPreferredProject->project_name : '';

                $lp .= '<tr>

                            <td>' . $data->enquirer_name . '</td>

                            <td>' . $newDate  . '</td>

                            <td>' . $lead_stage . '</td>

                            <td>' . $source . '</td>

                            <td>' . $project_type . '</td>

                            <td>' . $pref_project . '</td>

                            <td>' . $attended_by . '</td>

                            <td>' . $data->phone_code . ' ' . $data->mobile . '</td>

                            <td>' . $data->email . '</td>

                            <td><a href="' . url('/dashboard/leads/view/' . $data->id) . '" class="lead-view" data-id="' . $data->id . '">View</a></td>



                        </tr>';

                // $str .="<p>Attended By : ".$attended_by."<br>Lead Name : ".$data->enquirer_name."<br><a href='".url('/dashboard/leads/view/'.$data->id)."' class='lead-view' data-id='".$data->id."'>View</a></p>";
            }

            $str2 .= '</tbody>

                    </table>';

            $str = $str1 . $lp . $str2;
        }

        //     }else{

        //         $str1 .='<table>

        //                    <thead>

        //                 <th>Enquirer Name</th>

        //                 <th>Enq Date</th>

        //                 <th>Stage</th>

        //                 <th>Source</th>

        //                 <th>Project</th>

        //                 <th>Project Type</th>

        //                 <th>Attended By</th>

        //                 <th>Mobile</th>

        //                 <th>Email</th>

        //                 <th>View</th>

        //                 </thead><tbody>';

        //         $attended_by = isset($lead_det->getAttendedBy) ? $lead_det->getAttendedBy->name : '';

        //         $data = $lead_det;

        //         $orgDate = $data->created_at;

        //  $newDate = date("d-m-Y", strtotime($orgDate));

        //  $lead_stage = isset($data->getLeadStage) ? $data->getLeadStage->name : "";

        //  $source = isset($data->getSource) ? $data->getSource->name : "-";

        //  $project_type = isset($data->getProjectType) ? $data->getProjectType->name : "";

        //  $pref_project = isset($data->getPreferredProject) ? $data->getPreferredProject->project_name : "";

        //         $lp.='<tr>

        //                         <td>'.$data->enquirer_name.'</td>

        //                         <td>'.$newDate."b".'</td>

        //                         <td>'.$lead_stage.'</td>

        //                         <td>'.$source.'</td>

        //                         <td>'.$project_type.'</td>

        //                         <td>'.$pref_project.'</td>

        //                         <td>'.$attended_by.'</td>

        //                         <td>'.$data->phone_code." ".$data->mobile.'</td>

        //                         <td>'.$data->email.'</td>

        //                         <td><a href="'.url("/dashboard/leads/view/".$data->id).'" class="lead-view" data-id="'.$data->id.'">View</a></td>

        //                     </tr>';

        //                 // $str .="<p>Attended By : ".$attended_by."<br>Lead Name : ".$lead_det->enquirer_name."<br><a href='".url('/dashboard/leads/view/'.$lead_det->id)."' class='lead-view' data-id='".$lead_det->id."'>View</a></p>";

        //                 $str = $str1.$lp.$str2;

        //     }

        return response()->json(['data' => $str, 'status' => 200], 200);

        exit;
    }
    public function getDuplicateBankLeads(Request $request)
    { // Mobile duplicate
        $lead_id = $request->lead_id;

        $lead_det = \App\LeadBank::find($lead_id);



        $mb = $lead_det->mobile;

        $phone_code = $lead_det->phone_code;

        $str = '';

        $str1 = '';

        $lp = '';

        $str2 = '';

        // if (empty($lead_det->attended_by)) {

        $dup_leads = \App\LeadBank::where('mobile', $mb)->where('id', '<>', $lead_id)->get();


        if (isset($dup_leads) && count($dup_leads) > 0) {
        } else {
            $mbb = $phone_code . $mb;

            $dup_leads = \App\LeadBank::where('mobile', $mbb)->where('id', '<>', $lead_id)->get();




            if (isset($dup_leads) && count($dup_leads) > 0) {
            } else {
                $n = 10;

                $start = strlen($mb) - $n;

                $last_str = substr($mb, $start);

                if ($start >= 0) {
                    $dup_leads = \App\LeadBank::where('mobile', 'LIKE', '%' . $last_str . '%')->where('id', '<>', $lead_id)->get();

                    // dd($dup_leads);
                }
            }
        }



        if (isset($dup_leads) && count($dup_leads) > 0) {
            $str1 .= '<table>

                       <thead>

                       <th>Enquirer Name</th>

                    <th>Enq Date</th>

                    <th>Stage</th>

                    <th>Source</th>

                    <th>Project</th>

                    <th>Project Type</th>

                    <th>Attended By</th>

                    <th>Mobile</th>

                    <th>Email</th>



                    </thead><tbody>';

            foreach ($dup_leads as $data) {
                $id = $data->id;

                $attended_by = isset($data->getAttendedBy) ? $data->getAttendedBy->name : '';

                $orgDate = $data->created_at;

                $newDate = date('d-m-Y', strtotime($orgDate));

                $lead_stage = isset($data->getLeadStage) ? $data->getLeadStage->name : '';

                $source = isset($data->getSource) ? $data->getSource->name : '';

                $project_type = isset($data->getProjectType) ? $data->getProjectType->name : '';

                $pref_project = isset($data->getPreferredProject) ? $data->getPreferredProject->project_name : '';

                $lp .= '<tr>

                            <td>' . $data->enquirer_name . '</td>

                            <td>' . $newDate  . '</td>

                            <td>' . $lead_stage . '</td>

                            <td>' . $source . '</td>
                            <td>' . $pref_project . '</td>

                            <td>' . $project_type . '</td>
                            <td>' . $attended_by . '</td>

                            <td>' . $data->phone_code . ' ' . $data->mobile . '</td>

                            <td>' . $data->email . '</td>





                        </tr>';

                // $str .="<p>Attended By : ".$attended_by."<br>Lead Name : ".$data->enquirer_name."<br><a href='".url('/dashboard/leads/view/'.$data->id)."' class='lead-view' data-id='".$data->id."'>View</a></p>";
            }

            $str2 .= '</tbody>

                    </table>';

            $str = $str1 . $lp . $str2;
        }

        //     }else{

        //         $str1 .='<table>

        //                    <thead>

        //                 <th>Enquirer Name</th>

        //                 <th>Enq Date</th>

        //                 <th>Stage</th>

        //                 <th>Source</th>

        //                 <th>Project</th>

        //                 <th>Project Type</th>

        //                 <th>Attended By</th>

        //                 <th>Mobile</th>

        //                 <th>Email</th>

        //                 <th>View</th>

        //                 </thead><tbody>';

        //         $attended_by = isset($lead_det->getAttendedBy) ? $lead_det->getAttendedBy->name : '';

        //         $data = $lead_det;

        //         $orgDate = $data->created_at;

        //  $newDate = date("d-m-Y", strtotime($orgDate));

        //  $lead_stage = isset($data->getLeadStage) ? $data->getLeadStage->name : "";

        //  $source = isset($data->getSource) ? $data->getSource->name : "-";

        //  $project_type = isset($data->getProjectType) ? $data->getProjectType->name : "";

        //  $pref_project = isset($data->getPreferredProject) ? $data->getPreferredProject->project_name : "";

        //         $lp.='<tr>

        //                         <td>'.$data->enquirer_name.'</td>

        //                         <td>'.$newDate."b".'</td>

        //                         <td>'.$lead_stage.'</td>

        //                         <td>'.$source.'</td>

        //                         <td>'.$project_type.'</td>

        //                         <td>'.$pref_project.'</td>

        //                         <td>'.$attended_by.'</td>

        //                         <td>'.$data->phone_code." ".$data->mobile.'</td>

        //                         <td>'.$data->email.'</td>

        //                         <td><a href="'.url("/dashboard/leads/view/".$data->id).'" class="lead-view" data-id="'.$data->id.'">View</a></td>

        //                     </tr>';

        //                 // $str .="<p>Attended By : ".$attended_by."<br>Lead Name : ".$lead_det->enquirer_name."<br><a href='".url('/dashboard/leads/view/'.$lead_det->id)."' class='lead-view' data-id='".$lead_det->id."'>View</a></p>";

        //                 $str = $str1.$lp.$str2;

        //     }

        return response()->json(['data' => $str, 'status' => 200], 200);

        exit;
    }

    //duplicateleads Show for leadmaker

    public function getDuplicateLeadsMaker(Request $request)
    { // Mobile duplicate
        $lead_id = $request->lead_id;

        $lead_det = \App\Lead::find($lead_id);

        $mb = $lead_det->mobile;

        $phone_code = $lead_det->phone_code;

        $str = '';

        $str1 = '';

        $lp = '';

        $str2 = '';

        // if (empty($lead_det->attended_by)) {

        $dup_leads = \App\Lead::where('mobile', $mb)->where('id', '<>', $lead_id)->get();

        if (isset($dup_leads) && count($dup_leads) > 0) {
        } else {
            $mbb = $phone_code . $mb;

            $dup_leads = \App\Lead::where('mobile', $mbb)->where('id', '<>', $lead_id)->get();

            if (isset($dup_leads) && count($dup_leads) > 0) {
            } else {
                $n = 10;

                $start = strlen($mb) - $n;

                $last_str = substr($mb, $start);

                if ($start >= 0) {
                    $dup_leads = \App\Lead::where('mobile', 'LIKE', '%' . $last_str . '%')->where('id', '<>', $lead_id)->get();
                }
            }
        }

        if (isset($dup_leads) && count($dup_leads) > 0) {
            $str1 .= '<table>

                       <thead>

                       <th>Enquirer Name</th>

                    <th>Enq Date</th>

                    <th>Stage</th>

                    <th>Source</th>

                    <th>Project</th>

                    <th>Project Type</th>



                    <th>Mobile</th>

                    <th>Email</th>

                    <th>View</th>

                    </thead><tbody>';

            foreach ($dup_leads as $data) {
                $id = $data->id;

                $attended_by = isset($data->getAttendedBy) ? $data->getAttendedBy->name : '';

                $orgDate = $data->created_at;

                $newDate = date('d-m-Y', strtotime($orgDate));

                $lead_stage = isset($data->getLeadStage) ? $data->getLeadStage->name : '';

                $source = isset($data->getSource) ? $data->getSource->name : '';

                $project_type = isset($data->getProjectType) ? $data->getProjectType->name : '';

                $pref_project = isset($data->getPreferredProject) ? $data->getPreferredProject->project_name : '';

                $lp .= '<tr>

                            <td>' . $data->enquirer_name . '</td>

                            <td>' . $newDate . '</td>

                            <td>' . $lead_stage . '</td>

                            <td>' . $source . '</td>

                            <td>' . $project_type . '</td>

                            <td>' . $pref_project . '</td>



                            <td>' . $data->phone_code . ' ' . $data->mobile . '</td>

                            <td>' . $data->email . '</td>

                            <td><a href="' . url('/dashboard/leads/view/' . $data->id) . '" class="lead-view" data-id="' . $data->id . '">View</a></td>



                        </tr>';

                // $str .="<p>Attended By : ".$attended_by."<br>Lead Name : ".$data->enquirer_name."<br><a href='".url('/dashboard/leads/view/'.$data->id)."' class='lead-view' data-id='".$data->id."'>View</a></p>";
            }

            $str2 .= '</tbody>

                    </table>';

            $str = $str1 . $lp . $str2;
        }

        return response()->json(['data' => $str, 'status' => 200], 200);

        exit;
    }

    public function getDuplicateLeadsEmail(Request $request)
    { // Email duplicates checking
        $lead_id = $request->lead_id;

        $lead_det = \App\Lead::find($lead_id);

        $email = $lead_det->email;

        $str = '';

        $str1 = '';

        $lp = '';

        $str2 = '';

        //if (empty($lead_det->attended_by)) {

        $dup_leads = \App\Lead::where('email', $email)->where('id', '<>', $lead_id)->get();

        if (isset($dup_leads) && count($dup_leads) > 0) {
            $str1 .= '<table>

                       <thead>

                       <th>Enquirer Name</th>

                    <th>Enq Date</th>

                    <th>Stage</th>

                    <th>Source</th>

                    <th>Project</th>

                    <th>Project Type</th>

                    <th>Attended By</th>

                    <th>Mobile</th>

                    <th>Email</th>

                    <th>View</th>

                    </thead><tbody>';

            foreach ($dup_leads as $data) {
                $id = $data->id;

                $attended_by = isset($data->getAttendedBy) ? $data->getAttendedBy->name : '';

                $orgDate = $data->created_at;

                $newDate = date('d-m-Y', strtotime($orgDate));

                $lead_stage = isset($data->getLeadStage) ? $data->getLeadStage->name : '';

                $source = isset($data->getSource) ? $data->getSource->name : '';

                $project_type = isset($data->getProjectType) ? $data->getProjectType->name : '';

                $pref_project = isset($data->getPreferredProject) ? $data->getPreferredProject->project_name : '';

                $lp .= '<tr>

                            <td>' . $data->enquirer_name . '</td>

                            <td>' . $newDate .  '</td>

                            <td>' . $lead_stage . '</td>

                            <td>' . $source . '</td>

                            <td>' . $project_type . '</td>

                            <td>' . $pref_project . '</td>

                            <td>' . $attended_by . '</td>

                            <td>' . $data->phone_code . ' ' . $data->mobile . '</td>

                            <td>' . $data->email . '</td>

                            <td><a href="' . url('/dashboard/leads/view/' . $data->id) . '" class="lead-view" data-id="' . $data->id . '">View</a></td>



                        </tr>';

                // $str .="<p>Attended By : ".$attended_by."<br>Lead Name : ".$data->enquirer_name."<br><a href='".url('/dashboard/leads/view/'.$data->id)."' class='lead-view' data-id='".$data->id."'>View</a></p>";
            }

            $str2 .= '</tbody>

                    </table>';

            $str = $str1 . $lp . $str2;
        }

        //     }else{

        //         $str1 .='<table>

        //                    <thead>

        //                 <th>Enquirer Name</th>

        //                 <th>Enq Date</th>

        //                 <th>Stage</th>

        //                 <th>Source</th>

        //                 <th>Project</th>

        //                 <th>Project Type</th>

        //                 <th>Attended By</th>

        //                 <th>Mobile</th>

        //                 <th>Email</th>

        //                 <th>View</th>

        //                 </thead><tbody>';

        //         $attended_by = isset($lead_det->getAttendedBy) ? $lead_det->getAttendedBy->name : '';

        //         $data = $lead_det;

        //         $orgDate = $data->created_at;

        //  $newDate = date("d-m-Y", strtotime($orgDate));

        //  $lead_stage = isset($data->getLeadStage) ? $data->getLeadStage->name : "";

        //  $source = isset($data->getSource) ? $data->getSource->name : "-";

        //  $project_type = isset($data->getProjectType) ? $data->getProjectType->name : "";

        //  $pref_project = isset($data->getPreferredProject) ? $data->getPreferredProject->project_name : "";

        //         $lp.='<tr>

        //                         <td>'.$data->enquirer_name.'</td>

        //                         <td>'.$newDate."b".'</td>

        //                         <td>'.$lead_stage.'</td>

        //                         <td>'.$source.'</td>

        //                         <td>'.$project_type.'</td>

        //                         <td>'.$pref_project.'</td>

        //                         <td>'.$attended_by.'</td>

        //                         <td>'.$data->phone_code." ".$data->mobile.'</td>

        //                         <td>'.$data->email.'</td>

        //                         <td><a href="'.url("/dashboard/leads/view/".$data->id).'" class="lead-view" data-id="'.$data->id.'">View</a></td>

        //                     </tr>';

        //                 // $str .="<p>Attended By : ".$attended_by."<br>Lead Name : ".$lead_det->enquirer_name."<br><a href='".url('/dashboard/leads/view/'.$lead_det->id)."' class='lead-view' data-id='".$lead_det->id."'>View</a></p>";

        //                 $str = $str1.$lp.$str2;

        //     }

        return response()->json(['data' => $str, 'status' => 200], 200);

        exit;
    }
    public function getDuplicateLeadsBankEmail(Request $request)
    { // Email duplicates checking
        $lead_id = $request->lead_id;

        $lead_det = \App\LeadBank::find($lead_id);

        $email = $lead_det->email;

        $str = '';

        $str1 = '';

        $lp = '';

        $str2 = '';

        //if (empty($lead_det->attended_by)) {

        $dup_leads = \App\LeadBank::where('email', $email)->where('id', '<>', $lead_id)->get();

        if (isset($dup_leads) && count($dup_leads) > 0) {
            $str1 .= '<table>

                       <thead>

                       <th>Enquirer Name</th>

                    <th>Enq Date</th>

                    <th>Stage</th>

                    <th>Source</th>

                    <th>Project</th>

                    <th>Project Type</th>

                    <th>Attended By</th>

                    <th>Mobile</th>

                    <th>Email</th>



                    </thead><tbody>';

            foreach ($dup_leads as $data) {
                $id = $data->id;

                $attended_by = isset($data->getAttendedBy) ? $data->getAttendedBy->name : '';

                $orgDate = $data->created_at;

                $newDate = date('d-m-Y', strtotime($orgDate));

                $lead_stage = isset($data->getLeadStage) ? $data->getLeadStage->name : '';

                $source = isset($data->getSource) ? $data->getSource->name : '';

                $project_type = isset($data->getProjectType) ? $data->getProjectType->name : '';

                $pref_project = isset($data->getPreferredProject) ? $data->getPreferredProject->project_name : '';

                $lp .= '<tr>

                            <td>' . $data->enquirer_name . '</td>

                            <td>' . $newDate .  '</td>

                            <td>' . $lead_stage . '</td>

                            <td>' . $source . '</td>
                            <td>' . $pref_project . '</td>
                            <td>' . $project_type . '</td>

                            <td>' . $attended_by . '</td>

                            <td>' . $data->phone_code . ' ' . $data->mobile . '</td>

                            <td>' . $data->email . '</td>




                        </tr>';

                // $str .="<p>Attended By : ".$attended_by."<br>Lead Name : ".$data->enquirer_name."<br><a href='".url('/dashboard/leads/view/'.$data->id)."' class='lead-view' data-id='".$data->id."'>View</a></p>";
            }

            $str2 .= '</tbody>

                    </table>';

            $str = $str1 . $lp . $str2;
        }

        //     }else{

        //         $str1 .='<table>

        //                    <thead>

        //                 <th>Enquirer Name</th>

        //                 <th>Enq Date</th>

        //                 <th>Stage</th>

        //                 <th>Source</th>

        //                 <th>Project</th>

        //                 <th>Project Type</th>

        //                 <th>Attended By</th>

        //                 <th>Mobile</th>

        //                 <th>Email</th>

        //                 <th>View</th>

        //                 </thead><tbody>';

        //         $attended_by = isset($lead_det->getAttendedBy) ? $lead_det->getAttendedBy->name : '';

        //         $data = $lead_det;

        //         $orgDate = $data->created_at;

        //  $newDate = date("d-m-Y", strtotime($orgDate));

        //  $lead_stage = isset($data->getLeadStage) ? $data->getLeadStage->name : "";

        //  $source = isset($data->getSource) ? $data->getSource->name : "-";

        //  $project_type = isset($data->getProjectType) ? $data->getProjectType->name : "";

        //  $pref_project = isset($data->getPreferredProject) ? $data->getPreferredProject->project_name : "";

        //         $lp.='<tr>

        //                         <td>'.$data->enquirer_name.'</td>

        //                         <td>'.$newDate."b".'</td>

        //                         <td>'.$lead_stage.'</td>

        //                         <td>'.$source.'</td>

        //                         <td>'.$project_type.'</td>

        //                         <td>'.$pref_project.'</td>

        //                         <td>'.$attended_by.'</td>

        //                         <td>'.$data->phone_code." ".$data->mobile.'</td>

        //                         <td>'.$data->email.'</td>

        //                         <td><a href="'.url("/dashboard/leads/view/".$data->id).'" class="lead-view" data-id="'.$data->id.'">View</a></td>

        //                     </tr>';

        //                 // $str .="<p>Attended By : ".$attended_by."<br>Lead Name : ".$lead_det->enquirer_name."<br><a href='".url('/dashboard/leads/view/'.$lead_det->id)."' class='lead-view' data-id='".$lead_det->id."'>View</a></p>";

        //                 $str = $str1.$lp.$str2;

        //     }

        return response()->json(['data' => $str, 'status' => 200], 200);

        exit;
    }

    //duplicate function only for screener and maker
    public function getDuplicateLeadsEmailMaker(Request $request)
    { // Email duplicates checking
        $lead_id = $request->lead_id;

        $lead_det = \App\Lead::find($lead_id);

        $email = $lead_det->email;

        $str = '';

        $str1 = '';

        $lp = '';

        $str2 = '';

        //if (empty($lead_det->attended_by)) {

        $dup_leads = \App\Lead::where('email', $email)->where('id', '<>', $lead_id)->get();

        if (isset($dup_leads) && count($dup_leads) > 0) {
            $str1 .= '<table>

                       <thead>

                       <th>Enquirer Name</th>

                    <th>Enq Date</th>

                    <th>Stage</th>

                    <th>Source</th>

                    <th>Project</th>

                    <th>Project Type</th>


                    <th>Mobile</th>

                    <th>Email</th>

                    <th>View</th>

                    </thead><tbody>';

            foreach ($dup_leads as $data) {
                $id = $data->id;

                $attended_by = isset($data->getAttendedBy) ? $data->getAttendedBy->name : '';

                $orgDate = $data->created_at;

                $newDate = date('d-m-Y', strtotime($orgDate));

                $lead_stage = isset($data->getLeadStage) ? $data->getLeadStage->name : '';

                $source = isset($data->getSource) ? $data->getSource->name : '';

                $project_type = isset($data->getProjectType) ? $data->getProjectType->name : '';

                $pref_project = isset($data->getPreferredProject) ? $data->getPreferredProject->project_name : '';

                $lp .= '<tr>

                            <td>' . $data->enquirer_name . '</td>

                            <td>' . $newDate . '</td>

                            <td>' . $lead_stage . '</td>

                            <td>' . $source . '</td>

                            <td>' . $project_type . '</td>

                            <td>' . $pref_project . '</td>


                            <td>' . $data->phone_code . ' ' . $data->mobile . '</td>

                            <td>' . $data->email . '</td>

                            <td><a href="' . url('/dashboard/leads/view/' . $data->id) . '" class="lead-view" data-id="' . $data->id . '">View</a></td>



                        </tr>';

                // $str .="<p>Attended By : ".$attended_by."<br>Lead Name : ".$data->enquirer_name."<br><a href='".url('/dashboard/leads/view/'.$data->id)."' class='lead-view' data-id='".$data->id."'>View</a></p>";
            }

            $str2 .= '</tbody>

                    </table>';

            $str = $str1 . $lp . $str2;
        }

        return response()->json(['data' => $str, 'status' => 200], 200);

        exit;
    }

    public function getRemarks(Request $request)
    {
        $lead_id = $request->lead_id;

        $det = \App\Lead::find($lead_id);

        // $remarks = $det->remarks;
        $activity_subject = auth()->user()->name . ' Viewed remarks from sales person actions with id : ' . $lead_id;
        ActivityLog::addToLog($activity_subject, 'leads');

        return response()->json(['data' => $det, 'status' => 200], 200);

        exit;
    }

    public function deleteTask(Request $request)
    {
        $id = $request->id;

        \App\Task::find($id)->delete();

        // log Activity

        $activity_subject = \Auth::user()->name . ' deleted a task with ID : ' . $id;

        \ActivityLog::addToLog($activity_subject, 'leads');

        return response()->json(['msg' => 'Deleted', 'status' => 200], 200);

        exit;
    }

    public function deleteNote(Request $request)
    {


        $id = $request->id;

        \App\Note::find($id)->delete();

        // log Activity

        $activity_subject = \Auth::user()->name . ' deleted a document with ID : ' . $id;

        \ActivityLog::addToLog($activity_subject, 'leads');

        return response()->json(['msg' => 'Deleted', 'status' => 200], 200);

        exit;
    }

    public function deletesalesActivity(Request $request)
    {
        $id = $request->id;

        \App\SalesActivity::find($id)->delete();

        // log Activity

        $activity_subject = \Auth::user()->name . ' deleted a sales activity with ID : ' . $id;

        \ActivityLog::addToLog($activity_subject, 'leads');

        return response()->json(['msg' => 'Deleted', 'status' => 200], 200);

        exit;
    }

    public function deleteProjectBlock(Request $request)
    {
        $id = $request->id;

        \App\ProjectBlock::find($id)->delete();

        return response()->json(['msg' => 'Deleted', 'status' => 200], 200);

        exit;
    }

    public function deleteProjectUnit(Request $request)
    {
        $id = $request->id;

        \App\ProjectUnitType::find($id)->delete();

        $activity_subject = auth()->user()->name . ' deleted project unit with ID ' . $id;

        ActivityLog::addToLog($activity_subject, 'leads');

        return response()->json(['msg' => 'Deleted', 'status' => 200], 200);

        exit;
    }

    public function getProjectBlocks(Request $request)
    {
        $project_id = $request->project_id;

        $r = ProjectBlock::where('preferred_project_id', $project_id)->where('status', 1)->get();

        return response()->json(['data' => $r, 'status' => 200], 200);

        exit;
    }

    public function getProjectUnits(Request $request)
    {
        $sales_project = $request->sales_project;

        $r = PriceList::where('project_id', $sales_project)->where('status', 1)->where('booking_status_id', 1)->get();

        return response()->json(['data' => $r, 'status' => 200], 200);

        exit;
    }

    public function updatePerformance(Request $request)
    {
        $user_id = $request->user_id;

        $type = $request->type;

        $value = $request->value;

        $obj = \App\Performance::where('user_id', $user_id)->first();

        if (!$obj) {
            $obj = new \App\Performance();
        }

        $obj->user_id = $user_id;

        if ($type == 'unit') {
            $obj->no_of_unit = $value;
        } else {
            $obj->sale_value = $value;
        }

        $obj->created_at = date('Y-m-d');

        $obj->save();

        return response()->json(['msg' => 'success', 'status' => 200], 200);

        exit;
    }

    public function getSalespersonByEmail(Request $request)
    {

        $task = "";
        $email = $request->val_email;

        $dup_lead = \App\Lead::where('email', $email)->whereNotNull('attended_by')->get()->last();

        if ($dup_lead) {
            $task = Task::where('lead_id', $dup_lead->id)->get()->last();
        }

        $sixMonthBefore = now()->subMonths(6);

        $fifteenDays = now()->subDays(15);



        $attendedby = '';


        if (($dup_lead && $dup_lead->created_at >= $sixMonthBefore)) {

            $attendedby = isset($dup_lead->getAttendedBy) ? $dup_lead->getAttendedBy->name : '';
        } elseif ($task && $task->created_at >= $fifteenDays) {


            $attendedby = isset($dup_lead->getAttendedBy) ? $dup_lead->getAttendedBy->name : '';
        }


        return response()->json(['attendedby' => $attendedby, 'status' => 200], 200);

        exit;
    }

    public function duplicateEmailCheck(Request $request)
    {
        $email = $request->val_email;

        $dup_lead = \App\Lead::where('email', $email)->first();

        if ($dup_lead) {
            return response()->json(['message' => 'duplicate', 'status' => 200], 200);
        }

        return response()->json(['message' => 'new', 'status' => 200], 200);
    }

    public function duplicateMobileCheck(Request $request)
    {
        $mobile = $request->val_mobile;

        $phone_code = $request->country_code;
        $mbb = $phone_code . $mobile;

        $dup_lead = \App\Lead::where('mobile', $mobile)->orWhere('mobile', $mbb)->first();
        // $dup_lead = \App\Lead::where(function ($query) use ($mobile) {
        //     $mobileSub = \Str::substr($mobile, -9, 10);
        //     $query->where('mobile', 'like', '%'.$mobile)
        //     ->orWhere('mobile', 'sounds like', $mobileSub)
        //     ->orWhere('mobile', 'like', '% '.$mobileSub)
        //     ->orWhere('mobile', 'like', '%-'.$mobileSub);
        // })
        // ->first();

        if ($dup_lead) {
            return response()->json(['message' => 'duplicate', 'status' => 200], 200);
        }

        return response()->json(['message' => 'new', 'status' => 200], 200);
    }

    public function getSalespersonByMobile(Request $request)
    {

        $mobile = $request->val_mobile;

        $phone_code = $request->country_code;

        $dup_lead = \App\Lead::where('mobile', $mobile)->whereNotNull('attended_by')->get()->last();

        $task = Task::where('lead_id', $dup_lead->id)->get()->last();

        $mbb = $phone_code . $mobile;

        $dup_lead_mbb = \App\Lead::where('mobile', $mbb)->whereNotNull('attended_by')->get()->last();
        $fifteenDays = now()->subDays(15);


        $sixMonthBefore = now()->subMonths(6);
        $attendedby = '';

        if ($dup_lead && $dup_lead->created_at >= $sixMonthBefore) {
            $attendedby = isset($dup_lead->getAttendedBy) ? $dup_lead->getAttendedBy->name : '';
        } elseif ($dup_lead_mbb && $dup_lead_mbb->created_at >= $sixMonthBefore) {
            $attendedby = isset($dup_lead_mbb->getAttendedBy) ? $dup_lead_mbb->getAttendedBy->name : '';
        } elseif ($task && $task->created_at >= $fifteenDays) {

            $attendedby = isset($dup_lead->getAttendedBy) ? $dup_lead->getAttendedBy->name : '';
        }

        return response()->json(['attendedby' => $attendedby, 'status' => 200], 200);

        exit;
    }

    public function updateTaskCompletedStatus(Request $request)
    {


        $id = $request->task_id;

        $obj = \App\Task::find($id);

        $obj->task_completed_status = $request->task_completed_status;
        $obj->task_completion_remarks = $request->task_completion_remarks;

        $obj->updated_by = \Auth::user()->id;

        $obj->save();

        $activity_subject = auth()->user()->name . ' updated task completed status with id : ' . $obj->id;
        ActivityLog::addToLog($activity_subject, 'leads');

        // return response()->json(['msg' => 'Updated', 'error' => '', 'status' => 200], 200);

        return response()->json(['success' => '', 'status' => true, 'message' => 'Task status has been successfully updated.']);

        exit;
    }

    // public function searchAvailabilityChart(Request $request)
    // {
    //     $s_project = $request->s_project;
    //     $s_floor = $request->s_floor;
    //     $s_status = $request->s_status;
    //     $rows = PriceList::where('status', 1);

    //     if (!empty($s_project)) {
    //         $rows = $rows->where('project_id', $s_project);
    //     }
    //     if (!empty($s_floor)) {
    //         $rows = $rows->where('floor', $s_floor);
    //     }
    //     if (!empty($s_status)) {
    //         $rows = $rows->where('booking_status_id', $s_status);
    //     }
    //     $query = $rows;
    //     $records = $rows->groupBy('floor')->get(); //dd($records);

    //     $total_units = $query->count();
    //     $booked_count = $query->where('booking_status_id', 2)->where('status', 1)->count();
    //     $vacant_count = $query->where('booking_status_id', 1)->where('status', 1)->count();
    //     $onhold_count = $query->where('booking_status_id', 3)->where('status', 1)->count();
    //     $sold_count = $query->where('booking_status_id', 4)->where('status', 1)->count();
    //     $nfs_count = $query->where('booking_status_id', 5)->where('status', 1)->count();
    //     $investor_count = $query->where('booking_status_id', 5)->where('status', 1)->count();

    //     $counts_data = view('Dashboard.leads.availabilityChart.search-chart-counts', compact('total_units', 'booked_count', 'vacant_count', 'onhold_count', 'sold_count', 'nfs_count', 'investor_count'))->render();
    //     $floor_data = view('Dashboard.leads.availabilityChart.search-chart-floor', compact('records'))->render();

    //     return response()->json(['counts_data' => $counts_data, 'floor_data' => $floor_data, 'status' => 200], 200);

    //     exit;
    // }

    // public function getAvailabilityChartByBookingId(Request $request)
    // {
    //     $s_project = $request->s_project;
    //     $s_floor = $request->s_floor;
    //     $s_status = $request->s_status;
    //     $rows = PriceList::where('status', 1);

    //     if (!empty($s_project)) {
    //         $rows = $rows->where('project_id', $s_project);
    //     }
    //     if (!empty($s_floor)) {
    //         $rows = $rows->where('floor', $s_floor);
    //     }
    //     if (!empty($s_status)) {
    //         $rows = $rows->where('booking_status_id', $s_status);
    //     }

    //     $records = $rows->groupBy('floor')->get();

    //     $floor_data = view('dashboard.leads.availabilityChart.search-chart-floor', compact('records'))->render();

    //     return response()->json(['floor_data' => $floor_data, 'status' => 200], 200);

    //     exit;
    // }
}
