<?php

namespace App\Http\Controllers\Dashboard;

use App\User;
use Redirect;
use App\Helpers\ActivityLog;
use Illuminate\Http\Request;
use App\Rules\MatchOldPassword;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;

class ChangePasswordController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {

        $activity_subject = auth()->user()->name . ' viewed password change form';

        ActivityLog::addToLog($activity_subject, 'leads');
        return view('dashboard.change-password');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function update(Request $request)
    {
        $request->validate([
            'current_password' => ['required', new MatchOldPassword],
            'new_password' => ['required', 'min:8'],
            'new_confirm_password' => ['same:new_password'],
        ]);

        User::find(auth()->user()->id)->update(['password' => Hash::make($request->new_password)]);

        $activity_subject = auth()->user()->name . ' updated new password.';

        ActivityLog::addToLog($activity_subject, 'leads');

        return Redirect::to("dashboard/change-password")
            ->withSuccess('Password changed successfully');
    }
}
