<?php

namespace App\Http\Controllers\Dashboard;


use App\User;
use Redirect;
use Carbon\Carbon;
use App\Permission;
use App\ProjectType;
use App\PreferredProject;
use App\Helpers\ActivityLog;
use Illuminate\Http\Request;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use App\Role;
use App\Staff;
use Illuminate\Support\Facades\Hash;
use Yajra\DataTables\Facades\DataTables;

class DashboardController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */

    public function index(Request $request)
    {
        return view('dashboard.home');
    }

    public function logout()
    {
        $activity_subject = auth()->user()->name . ' logged out';
        ActivityLog::addToLog($activity_subject, 'leads');

        \Session::flush();
        \Auth::logout();

        return Redirect::to('/login');
    }

    public function addnewStaffs(Request $request)
    {
        $staffs = Staff::where('updated', 0)->get();

        foreach ($staffs as $staff) {

            $obj = User::create([
                'name' => $staff->name,
                'email' => $staff->name . '@gmail.com',
                'password' => Hash::make($staff->name),
                'joining_date' => ($staff->doj) ? Carbon::parse($staff->doj)->format('Y-m-d') : NULL,
                'designation' => $staff->designation,
                'department' => $staff->department,
                'mobile' => $staff->mobile,
                'gender' => $staff->gender,
                'blood_group' => $staff->blood,
                'date_of_birth' => ($staff->dob) ? Carbon::parse($staff->dob)->format('Y-m-d') : NULL,
                'marriage_anniversary' => ($staff->MARRIAGEANNIVERSARY) ? Carbon::parse($staff->MARRIAGEANNIVERSARY)->format('Y-m-d') : NULL,
                'address' => $staff->ADDRESS,
                'emergency_contact_no' => $staff->EMERGENCYCONTACTNUMBER,
                'esi_number' => $staff->esicn_no,
                'uan_number' => $staff->UANNUMBER,
                'aadhaar_number' => $staff->AADHAARNUMBER,
                'pan_number' => $staff->Pan,
                'account_number' => $staff->ACCOUNTDETAILS,
                'lwf_details' => ($staff->LWFDETAILS) ? Carbon::parse($staff->LWFDETAILS)->format('Y-m-d') : NULL,
                'uniform_given' => ($staff->UNIFORMGIVEN) ? Carbon::parse($staff->UNIFORMGIVEN)->format('Y-m-d') : NULL,

            ]);
            $role_obj = Role::find(31);
            $obj->roles()->attach($role_obj);
            $staff->updated = 1;
            $staff->save();
        }
    }
}
