<?php

namespace App\Http\Controllers\Dashboard;
use App\Http\Controllers\Controller;

use App\PreferredProject;
use App\ProjectBlock;

use Illuminate\Http\Request;
use Validator,Redirect,Response,File;

class ProjectBlockController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index($preferred_project_id=null)
    {
        $pref_project = '';
        if($preferred_project_id){
            $rows = ProjectBlock::where('status',1)->where('preferred_project_id',$preferred_project_id)->orderBy('id','desc')->get();
            $pref_project = PreferredProject::find($preferred_project_id);
        }else{
            $rows = ProjectBlock::where('status',1)->orderBy('id','desc')->get();
        }
        
        return view('dashboard.project_blocks.index', compact('rows','preferred_project_id','pref_project'));
    }
    // public function create()
    // {
    //     $project_types = ProjectType::where('status',1)->get();
    //     return view('dashboard.preferred_projects.create',compact('project_types'));
    // }
    public function store(Request $request)
    { 
        $project_id = $request->project_id;
        $block_name = $request->block_name ? $request->block_name : array();
        
                
        $data = [
            'project_id'=>$project_id,
            'block_name'=>$block_name,
            
    ];
        $rules = [
            'project_id'=>['required'],
            'block_name'=>['required'],
            'block_name.0'=>['required'],
            
            
                    
    ];
        $validator = Validator::make($data,$rules);

        if ($validator->fails())
        {
           // return redirect()->back()->withErrors($validator)->withInput($request->all());
           return response()->json(['error'=>$validator->getMessageBag()->toArray(),'status'=>false,'message'=>'There were some problems with your input']);
           die;
        }
        
        if(is_array($block_name) && count($block_name)>0){
            foreach ($block_name as $key=>$v) {
                if (!empty($v)) {
                    $obj = new ProjectBlock();
                    $obj->preferred_project_id = $project_id;
                    $obj->name = $v;

                    $obj->save();
                }
            }
            return response()->json(['error'=>'','status'=>true,'message'=>'Project Block has been added successfully.']);
            die;
        }
       
        
       
 
         return response()->json(['error'=>'','status'=>false,'message'=>'Failed to add Project Block.']);
         die;
 
    }
    public function edit($id)
    {
       
        $row = ProjectBlock::find($id);
    
        return view('dashboard.project_blocks.edit',compact('row'));
        
    }
    public function update(Request $request)
    {
        $id = $request->id;
        $block_name = $request->block_name;
        
                
        $data = [
            'id'=>$id,
            'block_name'=>$block_name,
            
    ];
        $rules = [
            'id'=>['required'],
            'block_name'=>['required'],
            
            
                    
    ];
        $validator = Validator::make($data,$rules);

        if ($validator->fails())
        {
           
            return redirect()->back()->withErrors($validator)->withInput($request->all());
        }
        $obj = ProjectBlock::find($id);
        $obj->name = $block_name;
        
        
        
         if ($obj->save()) {
         
            return Redirect::to("dashboard/project-blocks/edit/".$id)
            ->withSuccess('Block has been updated successfully.');
         }
         return Redirect::to("dashboard/project-blocks/edit/".$id)
        ->withError('Failed to update block.');
 
    }
    public function view($id)
    {
        $row = PreferredProject::find($id);
        return view('dashboard.preferred_projects.view',compact('row'));
    }
}
