<?php

namespace App\Http\Controllers\Dashboard\RegistrationForm;

use PDF;
use App\Country;
use App\PriceList;
use Carbon\Carbon;
use App\Registration;
use App\PreferredProject;
use App\Helpers\ActivityLog;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Redirect;
use Yajra\DataTables\Facades\DataTables;
use App\Actions\Registration\CreateRegistrationAction;
use App\CoApplicant;
use App\Http\Requests\Registration\RegistrationRequest;
use App\Lead;
use App\Proposal;
use App\Receipt;
use App\SalesActivity;

class RegistrationFormController extends Controller
{
    public function index()
    {
        return View('dashboard.registrationForm.index');
    }

    public function list(Request $request)
    {
        $dateFrom = Carbon::now()->startOfMonth();
        $dateTo = Carbon::now()->endOfMonth();
        if ($request->s_from) {
            $dateFrom = Carbon::parse($request->s_from)->startOfDay()->format('Y-m-d H:i:s');
        }
        if ($request->s_to) {
            $dateTo = Carbon::parse($request->s_to)->endOfDay()->format('Y-m-d H:i:s');
        }
        $data = Registration::with('preferredProject', 'unit')->whereBetween('created_at', [$dateFrom, $dateTo]);

        if (
            !auth()->user()->hasRole('ceo') &&
            !auth()->user()->hasRole('super-admin')
            && !auth()->user()->hasRole('sales-head')
            && !auth()->user()->hasRole('sales-support')
            && !auth()->user()->hasRole('team-leader')
        ) {
            $data = $data->where('created_by', auth()->user()->id);
        }
        if (auth()->user()->hasRole('team-leader')) {
            $all_reporting_users_id_array = auth()->user()->getAllReportingUsersIds();
            array_push($all_reporting_users_id_array, auth()->user()->id);

            // dd($all_reporting_users_id_array);
            $data = $data->whereIn('created_by', $all_reporting_users_id_array);
        }

        return DataTables::of($data)
            ->addIndexColumn()
            ->editColumn('name', function ($data) {
                return $data->name_prefix . $data->name;
            })
            ->addColumn('project', function ($data) {
                return $data->preferredProject ? $data->preferredProject->project_name : "";
            })
            ->addColumn('unit', function ($data) {
                return $data->unit ? $data->unit->ap_no : "";
            })
            ->editColumn('mobile', function ($data) {
                return $data->mobile;
            })
            ->addColumn('action', function ($data) {
                return "<a onclick='downloadPDF($data->id)' class='btn' >Download PDF</a>";
            })
            ->rawColumns(['action'])
            ->make(true);
    }

    public function create(Request $request, PreferredProject $preferred_project)
    {
        $type = $request->type;
        $project = [
            'projectId' => $preferred_project->id,
            'projectName' => $preferred_project->project_name,
        ];
        $country_codes = Country::get();
        return View('dashboard.registrationForm.create', compact('type', 'project', 'country_codes'));
    }

    public function units(Request $request)
    {
        $units = PriceList::where('project_id', $request->project_id)->get();

        return response()->json(['data' => $units, 'status' => 200], 200);
    }

    public function store(RegistrationRequest $request, CreateRegistrationAction $createAction)
    {
        try {
            $registration = $createAction->execute(collect($request->validated()));
            if ($registration) {
                return Redirect::to('dashboard/registration-form/')
                    ->withSuccess('Registration successful');
            }

            return redirect()->back()->withErrors('Something Went Wrong,Please Try Again !');
        } catch (\Throwable $th) {
            info($th);

            return redirect()->back()->withErrors('Something Went Wrong,Please Try Again !');
        }
    }

    public function download(Request $request)
    {
        $registration = Registration::with('preferredProject', 'unit')->find($request->registration_id);
        $project = PreferredProject::find($registration->project_id);
        if ($project->project_type == 3) {
            $pdf = \PDF::loadView('dashboard.ApplicationForm.application', [
                'registration' => $registration,
                'project' => $project,
            ]);
        } else {
            $pdf = \PDF::loadView('dashboard.registrationForm.registrationFormPDF', [
                'registration' => $registration,
            ]);
        }

        if ($pdf) {
            $activity_subject = auth()->user()->name . ' Downloaded Registration Form  PDF with  id : ' . $registration->id;
            ActivityLog::addToLog($activity_subject, 'leads');
        } 
        // return $pdf->download('Proposal.pdf');
        return $pdf->stream($registration->name_prefix . $registration->name . '_' . $registration->id . '.pdf');
    }
    public function clientDownload($id)
    {
      
        $sale = SalesActivity::with('getLeads','getCoApplicants','getSalesOwner')->find($id);
        if(!$sale){
            return redirect()->back()->withErrors('Something Went Wrong,Please Try Again !');
        }
        $registration = Lead::find($sale->lead_id);
        $coapplicant = CoApplicant::where('lead_id',$sale->lead_id)->first();
        $proposal = Proposal::find($sale->proposal_id);
        $project = PreferredProject::find($sale->project);
        $priceList = PriceList::find($sale->project_unit);
        $receipt =Receipt::oldest()->where('sale_id',$sale->id)->first();
  
        if  ($project->getUnits()->count() == 0 && ($sale->project != 33 && $sale->project != 32 && $sale->project != 24)) {
        
            $pdf = \PDF::loadView('dashboard.ApplicationForm.application', [
                'registration' => $registration,
                'project' => $project,
                'sale' => $sale,
                'proposal' => $proposal,
                'priceList' => $priceList,
                'receipt' => $receipt
            ]);
            
        }
        // else if ($project->project_type == 2) {
        //     $pdf = \PDF::loadView('dashboard.ApplicationForm.application', [
        //         'registration' => $registration,
        //         'project' => $project,
        //         'sale'=> $sale,
        //         'proposal' => $proposal,
        //         'priceList'=> $priceList,
        //         'receipt'=> $receipt
        //     ]);
        // }
        
         else {
          
            $pdf = \PDF::loadView('dashboard.registrationForm.CustomerRegistrationForm', [
                'customer' => $registration,
                'coapplicant'=>$coapplicant,
                'sale'=>$sale,
                'proposal' => $proposal,
                'project' => $project,
                'priceList'=> $priceList,
                'receipt'=> $receipt
            ]);
        }

        if ($pdf) {
            $activity_subject = auth()->user()->name . ' Downloaded Client Registration Form  PDF with  id : ' . $registration->id;
            ActivityLog::addToLog($activity_subject, 'leads');
        }
        // return $pdf->download('Proposal.pdf');
        return $pdf->stream($registration->name_prefix . $registration->enquirer_name . '_' . $registration->id . '.pdf');
    }
}
