<?php

namespace App\Http\Controllers\Dashboard;

use App\Role;
use App\User;

use App\Permission;

use App\RolePermission;
use App\Helpers\ActivityLog;
use Illuminate\Http\Request;


use App\Http\Controllers\Controller;
use Validator,Redirect,Response,File;

class RoleController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
        $rows = Role::all();

        $activity_subject = auth()->user()->name .' viewed roles list';
        ActivityLog::addToLog($activity_subject, 'leads');

        return view('dashboard.roles.index', compact('rows'));
    }
    public function create()
    {
        $leadsPermissions = Permission::where('type','leads')->get();
        $crmPermissions = Permission::where('type','crm')->get();
         $permissions = [];
        
        $activity_subject = auth()->user()->name .' viewed roles add form';
        ActivityLog::addToLog($activity_subject, 'leads');

        return view('dashboard.roles.create',compact('permissions','leadsPermissions','crmPermissions'));
    }
    public function store(Request $request)
    {
        $name = $request->name;
        $slug = $request->slug;
        $permission = $request->permission ? $request->permission : array();
        
        $data = ['name'=>$name,
                    'slug'=>$slug,
                    'permission'=>$permission,
                    
    
    ];
        $rules = [
            'name'=>['required'],
            'slug'=>['required', 'unique:roles,name', 'max:255'],
            'permission' => ['required'],
            
                    
    ];
        $validator = Validator::make($data,$rules);

        if ($validator->fails())
        {
            return redirect()->back()->withErrors($validator)->withInput($request->all());
        }
        $obj = new Role();
        $obj->name = $name;
        $obj->slug= $slug;
        
        
         if ($obj->save()) {
             if(is_array($permission) && count($permission)){
                 foreach($permission as $p){
                $obj_ = new RolePermission();
                $obj_->role_id = $obj->id;
                $obj_->permission_id = $p;
                $obj_->save();
                 }
             }

             $activity_subject = auth()->user()->name .' added new role with name '.$obj->name;
             ActivityLog::addToLog($activity_subject, 'leads');

             
            return Redirect::to("dashboard/roles")
        ->withSuccess('Role has been added successfully.');
         } 
 
        return Redirect::to("dashboard/roles")
        ->withError('Failed to add Role.');
 
    }
    public function edit($id)
    {
        $row = Role::find($id);
        $leadsPermissions = Permission::where('type','leads')->get();
        $crmPermissions = Permission::where('type','crm')->get();
        $active_permissions = RolePermission::where('role_id',$id)->pluck('permission_id')->toArray();

        $activity_subject = auth()->user()->name .' viewed role edit form with id '.$row->id;
        ActivityLog::addToLog($activity_subject, 'leads');
        
        return view('dashboard.roles.edit',compact('row','active_permissions','leadsPermissions','crmPermissions'));
        
    }
    public function update(Request $request)
    {
        $id = $request->id;
        $name = $request->name;
       // $slug = $request->slug;
        $permission = $request->permission ? $request->permission : array();
        
        $data = ['name'=>$name,
                   // 'slug'=>$slug,
                    'permission'=>$permission,
                    
    
    ];
        $rules = [
            'name'=>['required'],
            //'slug'=>['required', 'unique:roles,name', 'max:255'],
            'permission' => ['required'],
            
                    
    ];
        
        $validator = Validator::make($data,$rules);

        if ($validator->fails())
        {
            return redirect()->back()->withErrors($validator)->withInput($request->all());
        }
        $obj = Role::find($id);
        $obj->name = $name;
        
        
        
         if ($obj->save()) {
             if(is_array($permission) && count($permission)){
                 RolePermission::where('role_id',$id)->delete();
                 foreach($permission as $p){
                $obj_ = new RolePermission();
                $obj_->role_id = $obj->id;
                $obj_->permission_id = $p;
                $obj_->save();
                 }
             }

             
        $activity_subject = auth()->user()->name .' updated role with id '.$obj->id;
        ActivityLog::addToLog($activity_subject, 'leads');

        
            return Redirect::to("dashboard/roles")
            ->withSuccess('Role has been updated successfully.');
         } 

 
        return Redirect::to("dashboard/roles")
        ->withError('Role has been updated successfully.');
 
    }
}
