<?php

namespace App\Http\Controllers;

use App\LeadBank;
use App\LeadBankNew;
use Illuminate\Http\Request;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
        return view('dashboard.home');
    }



    public function leadsBankDuplicates()
    {
        $check = false;
        $leads_bank_duplicates = LeadBank::where('duplicate_update',0)->limit(50000)->get();

        foreach ($leads_bank_duplicates as $key => $leads_bank_duplicate) {
          
            $leads_bank_duplicate->duplicate_update = 1;
            $leads_bank_duplicate->save();

           
            if (!empty($leads_bank_duplicate->mobile)) {

                $check = LeadBankNew::where('mobile', $leads_bank_duplicate->mobile)->get()->last();
    
                // $task = Task::where('lead_id', $check->id)->get()->last();
                if (!$check) {
                    $mbb = $leads_bank_duplicate->phone_code.$leads_bank_duplicate->mobile;
                    $check = LeadBankNew::where('mobile', $mbb)->get()->last();
                    if (!$check) {
                        $check = LeadBankNew::where('phone_code', $leads_bank_duplicate->phone_code)->where('mobile', $leads_bank_duplicate->mobile)->get()->last();
    
                        if (!$check) {
                            $n = 10;
    
                            if (strlen($leads_bank_duplicate->mobile) == 9) {
                                $n = 9;
                            }
    
                            if (strlen($leads_bank_duplicate->mobile) == 8) {
                                $n = 8;
                            }
    
                            $start = strlen($leads_bank_duplicate->mobile) - $n;
                            $last_str = substr($leads_bank_duplicate->mobile, $start);
                            if ($start >= 0) {
                                $check = LeadBankNew::where('mobile', 'LIKE', '%'.$last_str.'%')->get()->last();
                            }
                        }
                    }
                }
           
                if (!$check) {
                    $leadBankArray = $leads_bank_duplicate->toArray(); 
                   unset($leadBankArray['id']);
                   
                    LeadBankNew::insert($leadBankArray);
                }
            }
            
        }
    }
}
