<?php

namespace App\Http\Controllers\MallSoftware;

use App\Http\Controllers\Controller;
use App\LesseEntry;
use App\Project;
use App\RateItemDefinition;

class BillDetailsEntryController extends Controller
{
    public function index()
    {
        return view('mall_software.bill_details_entry.index');
    }

    public function fixedChargesIndex()
    {
        $lessees = LesseEntry::get();
        $projects = Project::get();
        $rate_items = RateItemDefinition::get();
        return view('mall_software.bill_details_entry.bill_entry_fixed_charges', compact('projects', 'rate_items', 'lessees'));
    }

    public function variableChargesIndex()
    {
        $projects = Project::get();
        $lessees = LesseEntry::get();
        $rate_items = RateItemDefinition::get();
        return view('mall_software.bill_details_entry.bill_entry_variable_charges', compact('projects', 'rate_items', 'lessees'));
    }

    public function depositsIndex()
    {
        $projects = Project::get();
        $rate_items = RateItemDefinition::get();
        $lessees = LesseEntry::get();
        return view('mall_software.bill_details_entry.bill_entry_deposits', compact('projects', 'rate_items', 'lessees'));
    }

    public function otherChargesIndex()
    {
        $projects = Project::get();
        $rate_items = RateItemDefinition::get();
        return view('mall_software.bill_details_entry.bill_entry_other_charges', compact('projects', 'rate_items'));
    }
}
