<?php

namespace App\Http\Controllers\MallSoftware;

use App\Company;
use App\Country;
use App\State;
use App\Http\Controllers\Controller;
use App\Http\Requests\MallSoftware\Company\CreateCompanyRequest;
use App\Actions\MallSoftware\Company\CreateCompanyAction;
use Illuminate\Http\Request;
use Yajra\DataTables\Facades\DataTables;

class CompanyController extends Controller
{
    public function index()
    {
        return view('mall_software.settings.company.index');
    }

    public function getCompanyList(Request $request)
    {
        $country_id = $request->country_id;
        $data = Company::orderBy('created_at', 'asc');

        $data->when($country_id, function ($q, $country_id) {
            return $q->where('country_id', $country_id);
        });

        return DataTables::of($data)
            ->addIndexColumn()
            ->editColumn('parent_company_id', function ($data) {
                $attended_by = isset ($data->getParent) ? $data->getParent->title : '';

                return $attended_by;
            })
            ->addColumn('actions', function($data){
                $btn = '<a href="' . route("mall-software.companies_edit",$data->id) . '" class="btn">Edit</a>';
                return $btn;
            })
            ->rawColumns(['actions', 'parent_company_id'])
            ->make(true);
    }

    public function create()
    {
        $countries = Country::get();
        $parent_companies = Company::get();
        return view('mall_software.settings.company.create', compact('countries', 'parent_companies'));
    }

    public function store(CreateCompanyRequest $request, CreateCompanyAction $create_company_action)
    {
        $response = $create_company_action->execute(collect($request->validated()));
        if (!$response) {
            return response()->json(['error' => '', 'status' => false, 'message' => 'Failed to add Company.']);
        }
        return response()->json(['error' => '', 'status' => true, 'message' => 'Company has been added successfully.']);
    }

    public function edit(Request $request, Company $company)
    {
        $countries = Country::get();
        $states = State::where('country_id',$company->country_id)->get();
        $parent_companies = Company::where('id','!=',$company->id)->get();

        // $activity_subject = auth()->user()->name . ' viewed company edit form with id ' . $company->id;
        // ActivityLog::addToLog($activity_subject, 'finance');

        return view('mall_software.settings.company.edit', compact('company', 'countries','states','parent_companies'));
    }
}
