<?php

namespace App\Http\Controllers\MallSoftware;

use App\Actions\MallSoftware\LesseeEntry\LesseeEntryCompanyUpdateAction;
use App\Actions\MallSoftware\LesseeEntry\LesseeEntryIndividualUpdateAction;
use App\Actions\MallSoftware\LesseeEntry\LesseeEntryStoreAction;
use App\Country;
use App\GeoLocation;
use App\Http\Controllers\Controller;
use App\Http\Requests\MallSoftware\LesseeEntry\LesseeEntryCompanyUpdateRequest;
use App\Http\Requests\MallSoftware\LesseeEntry\LesseeEntryIndividualUpdateRequest;
use App\Http\Requests\MallSoftware\LesseeEntry\LesseeEntryStoreRequest;
use App\IndiaDistrict;
use App\IndiaState;
use App\LesseEntry;
use App\State;
use Illuminate\Http\Request;
use Yajra\DataTables\Facades\DataTables;

class LesseeEntryController extends Controller
{
    public function index()
    {
        return view('mall_software.lessee_entry.index');
    }
    public function individualLesseeList()
    {
        $data = LesseEntry::where('lessee_type', 'Individual')->get();
        return DataTables::of($data)
            ->addIndexColumn()
            ->addColumn('actions', function ($data) {
                $csrfField = csrf_field();
                $deleteRoute = route('mall-software.lessee_entry.destroy', $data->id);
                $editbtn = '<a href="' . route('mall-software.lessee_entry.individualLesseeEdit', $data->id) . '" class="btn">Edit</a>';
                $deletebtn = <<<HTML
                <form action="{$deleteRoute}" method="post" style ="display:inline">
                {$csrfField}
                <button type="submit" class="btn"><i class='fas fa-trash'></i></button>
                </form>
                HTML;
                return $editbtn . " " . $deletebtn;
            })
            ->rawColumns(['actions'])
            ->make(true);
    }

    public function companyLesseeList()
    {
        $data = LesseEntry::where('lessee_type', 'Company')->get();
        return DataTables::of($data)
            ->addIndexColumn()
            ->addColumn('actions', function ($data) {
                $csrfField = csrf_field();
                $deleteRoute = route('mall-software.lessee_entry.destroy', $data->id);
                $editbtn = '<a href="' . route('mall-software.lessee_entry.companyLesseeEdit', $data->id) . '" class="btn">Edit</a>';
                $deletebtn = <<<HTML
                <form action="{$deleteRoute}" method="post" style ="display:inline">
                {$csrfField}
                <button type="submit" class="btn"><i class='fas fa-trash'></i></button>
                </form>
                HTML;
                return $editbtn . " " . $deletebtn;
            })
            ->rawColumns(['actions'])
            ->make(true);
    }

    public function create()
    {
        $countries = Country::get();
        return view('mall_software.lessee_entry.create', compact('countries'));
    }
    public function getStates(Request $request)
    {
        if ($request->country_id == 101) {
            $states = GeoLocation::where('location_type', 'STATE')->get();
            return response()->json(['data' => $states, 'status' => true]);
        } else {
            $states = State::where('country_id', $request->country_id)->get();
            return response()->json(['data' => $states, 'status' => true]);
        }
    }

    public function getDistricts(Request $request)
    {
        $districts = IndiaDistrict::where('state_id', $request->state_id)->get();
        return response()->json(['data' => $districts, 'status' => true]);
    }

    public function store(LesseeEntryStoreRequest $request, LesseeEntryStoreAction $action)
    {
        try {
            $response = $action->execute(collect($request->validated()));
            if ($response) {
                return redirect()->route('mall-software.lessee_entry')->with('success', 'Successfully Created');
            }
            return redirect()->back()->with('error', 'Something went wrong, Please try again!');
        } catch (\Throwable $th) {
            info($th);
            return redirect()->back()->with('error', 'Something went wrong, Please try again!');
        }
    }

    public function individualLesseEdit(LesseEntry $lesseEntry)
    {
        $countries = Country::get();
        $pstates = "";
        $pdistricts = "";
        $cstates = "";
        $cdistricts = "";
        if ($lesseEntry->individual_permanent_country_id == 101) {
            $pstates = GeoLocation::where('location_type', 'STATE')->get();
            $pdistricts = GeoLocation::where(['location_type' => 'DISTRICT', 'parent_id' => $lesseEntry->individual_permanent_state_id])->get();
        } else {
            $pstates = State::get();
            $pdistricts = null;
        }
        // if ($lesseEntry->individual_permanent_state_id) {
        //     $pdistricts = GeoLocation::where(['location_type' => 'DISTRICT', 'parent_id' => $lesseEntry->individual_permanent_state_id])->get();
        // }
        if ($lesseEntry->individual_communication_country_id == 101) {
            $cstates = GeoLocation::where('location_type', 'STATE')->get();
        } else {
            $cstates = State::get();
            $cdistricts = null;
        }
        if ($lesseEntry->individual_communication_state_id) {
            $cdistricts = GeoLocation::where(['location_type' => 'DISTRICT', 'parent_id' => $lesseEntry->individual_communication_state_id])->get();
        }
        return view('mall_software.lessee_entry.individual_lessee_edit', compact('countries', 'lesseEntry', 'pstates', 'pdistricts', 'cstates', 'cdistricts'));
    }

    public function companyLesseEdit(LesseEntry $lesseEntry)
    {
        $countries = Country::get();
        $pstates = "";
        $pdistricts = "";
        $cstates = "";
        $cdistricts = "";
        if ($lesseEntry->company_permanent_country_id == 101) {
            $pstates = GeoLocation::where('location_type', 'STATE')->get();
            $pdistricts = GeoLocation::where(['location_type' => 'DISTRICT', 'parent_id' => $lesseEntry->company_permanent_state_id])->get();
        } else {
            $pstates = State::get();
            $pdistricts = null;
        }
        // if ($lesseEntry->company_permanent_state_id) {
        //     $pdistricts = GeoLocation::where(['location_type' => 'DISTRICT', 'parent_id' => $lesseEntry->company_permanent_state_id])->get();
        // }
        if ($lesseEntry->company_communication_country_id == 101) {
            $cstates = GeoLocation::where('location_type', 'STATE')->get();
        } else {
            $cstates = State::get();
            $cdistricts = null;
        }
        if ($lesseEntry->company_communication_state_id) {
            $cdistricts = GeoLocation::where(['location_type' => 'DISTRICT', 'parent_id' => $lesseEntry->company_communication_state_id])->get();
        }
        return view('mall_software.lessee_entry.company_lessee_edit', compact('countries', 'lesseEntry', 'pstates', 'pdistricts', 'cstates', 'cdistricts'));
    }

    public function individualUpdate(LesseeEntryIndividualUpdateRequest $request, LesseeEntryIndividualUpdateAction $action, LesseEntry $lesseEntry)
    {
        try {
            $response = $action->execute(collect($request->validated()), $lesseEntry);
            if ($response) {
                return redirect()->route('mall-software.lessee_entry')->with('success', 'Successfully Updated');
            }
            return redirect()->back()->with('error', 'Something went wrong, Please try again!');
        } catch (\Throwable $th) {
            info($th);
            return redirect()->back()->with('error', 'Something went wrong, Please try again!');
        }
    }

    public function companyUpdate(LesseeEntryCompanyUpdateRequest $request, LesseeEntryCompanyUpdateAction $action, LesseEntry $lesseEntry)
    {
        try {
            $response = $action->execute(collect($request->validated()), $lesseEntry);
            if ($response) {
                return redirect()->route('mall-software.lessee_entry')->with('success', 'Successfully Updated');
            }
            return redirect()->back()->with('error', 'Something went wrong, Please try again!');
        } catch (\Throwable $th) {
            info($th);
            return redirect()->back()->with('error', 'Something went wrong, Please try again!');
        }
    }

    public function destroy(LesseEntry $lesseEntry)
    {
        try {
            $lesseEntry->delete();
            return redirect()->route('mall-software.lessee_entry')->with('success', 'Successfully Deleted');
        } catch (\Throwable $th) {
            info($th);
            return redirect()->back()->with('error', 'Something went wrong, Please try again!');
        }
    }
}
