<?php

namespace App\Http\Controllers\MallSoftware;

use App\Project;
use App\Http\Controllers\Controller;
use App\Http\Requests\MallSoftware\Project\CreateProjectRequest;
use App\Actions\MallSoftware\Project\CreateProjectAction;
use Illuminate\Http\Request;
use Yajra\DataTables\Facades\DataTables;

class ProjectController extends Controller
{
    public function index()
    {
        return view('mall_software.settings.projects.index');
    }

    public function getProjectList()
    {
        $datas = Project::orderBy('created_at', 'asc');
        return DataTables::of($datas)
            ->addIndexColumn()
            ->addColumn('status', function($datas){
                if($datas->status == 1){
                    return '<label class="label label-success">Active</label>';
                }
                else{
                    return '<label class="label label-warning">Not Active</label>';
                }
            })
            ->addColumn('actions', function($data){
                $btn = '<a href="#" class="btn">Edit</a>';
                return $btn;
            })
            ->rawColumns(['actions', 'status'])
            ->make(true);
    }

    public function create()
    {
        return view('mall_software.settings.projects.create');
    }

}
