<?php
namespace App\Http\Controllers\MallSoftware;

use App\Actions\MallSoftware\RateItemDefinition\RateItemDefinitionStoreAction;
use App\Actions\MallSoftware\RateItemDefinition\RateItemDefinitionUpdateAction;
use App\Http\Controllers\Controller;
use App\Http\Requests\MallSoftware\RateItemDefinition\RateItemDefinitionStoreRequest;
use App\Http\Requests\MallSoftware\RateItemDefinition\RateItemDefinitionUpdateRequest;
use App\Ledger;
use App\RateItemDefinition;
use Illuminate\Http\Request;
use Yajra\DataTables\Facades\DataTables;

class RateItemDefinitionController extends Controller
{
    public function index()
    {
        return view('mall_software.rate_item_definition.index');
    }

    public function list()
    {
        $data = RateItemDefinition::with('getCoaGroupName')->get();
        return DataTables::of($data)
            ->addIndexColumn()
            ->addColumn('coa_group', function ($data) {
                return $data->getCoaGroupName->ledger_name;
            })
            ->addColumn('ledger_name', function ($data) {
                return $data->getLedgerName->ledger_name;
            })
            ->addColumn('actions', function ($data) {
                $csrfField = csrf_field();
                $deleteRoute = route('mall-software.rate_item_definition.destroy', $data->id);
                $btn = '<a href="' . route('mall-software.rate_item_definition.edit', $data->id) . '" class="btn">Edit</a>';
                $btn .= <<<HTML
                <form action="{$deleteRoute}" method="post" style ="display:inline">
                {$csrfField}
                <button type="submit" class="btn"><i class='fas fa-trash'></i></button>
                </form>
                HTML;
                return $btn;
            })
            ->rawColumns(['actions', 'coa_group', 'ledger_name'])
            ->make(true);
    }

    public function create()
    {
        $ledgerGroups = Ledger::where(['type' => "GROUP"])->get();
        $ledgers = Ledger::whereIn('coa_group', [1, 2])->get();
        return view('mall_software.rate_item_definition.create', compact('ledgerGroups', 'ledgers'));
    }

    public function getLedgers(Request $request)
    {
        $individualLedgers = Ledger::with('getLedgerName')->where('coa_group', $request->coa_id)->get();
        return response()->json(['data' => $individualLedgers, 'status' => true]);
    }

    public function store(RateItemDefinitionStoreRequest $request, RateItemDefinitionStoreAction $action)
    {
        try {
            $response = $action->execute(collect($request->validated()));
            if ($response) {
                return redirect()->route('mall-software.rate_item_definition')->with('success', 'Successfully created');
            }
            return redirect()->back()->with('error', 'Something went wrong, Please try again!');
        } catch (\Throwable $th) {
            info($th);
            return redirect()->back()->with('error', 'Something went wrong, Please try again!');
        }
    }

    public function edit(RateItemDefinition $rateItemDefinition)
    {
        $ledgerGroups = Ledger::where(['is_control_account' => 1, 'type' => "GROUP"])->get();
        $ledgers = Ledger::where('id', $rateItemDefinition->ledger_type)->get();
        return view('mall_software.rate_item_definition.edit', compact('rateItemDefinition', 'ledgerGroups', 'ledgers'));
    }

    public function update(RateItemDefinitionUpdateRequest $request, RateItemDefinitionUpdateAction $action, RateItemDefinition $rateItemDefinition)
    {
        try {
            $response = $action->execute(collect($request->validated()), $rateItemDefinition);
            if ($response) {
                return redirect()->route('mall-software.rate_item_definition')->with('success', 'Successfully updated');
            }
            return redirect()->back()->with('error', 'Something went wrong, Please try again!');
        } catch (\Throwable $th) {
            info($th);
            return redirect()->back()->with('error', 'Something went wrong, Please try again!');
        }
    }

    public function destroy(RateItemDefinition $rateItemDefinition)
    {
        try {
            $rateItemDefinition->delete();
            return redirect()->route('mall-software.rate_item_definition')->with('success', 'Successfully Deleted');
        } catch (\Throwable $th) {
            info($th);
            return redirect()->back()->with('error', 'Something went wrong, Please try again!');
        }
    }
}
