<?php
namespace App\Http\Controllers\MallSoftware;

use App\Http\Controllers\Controller;
use App\Role;
use Yajra\DataTables\DataTables;

class RolesController extends Controller
{
    public function index()
    {
        return view('mall_software.settings.roles.index');
    }

    public function getRolesList()
    {
        $roles = Role::with('permissions')->get();
        // return $roles;
        return DataTables::of($roles)
            ->addIndexColumn()
            ->addColumn('permissions', function($roles){
                if($roles->permissions){
                    $str = '' ;
                    foreach($roles->permissions as $permissions){
                        $str.=$permissions->name;
                        $str = $str.",";
                    }
                    return $str;
                }
            })
            ->addColumn('actions', function($roles){
                return '<a class="btn" href="">Update</a>';
            })
            ->removeColumn('id', 'created_at', 'updated_at')
            ->rawColumns(['actions'])
            ->toJson();
    }

    public function create()
    {
        return view('mall_software.settings.roles.create');
    }
}
