<?php

namespace App\Http\Controllers\MallSoftware;

use App\Actions\MallSoftware\UnitDefinitions\UnitDefinitionStoreAction;
use App\Actions\MallSoftware\UnitDefinitions\UnitDefinitionUpdateAction;
use App\Block;
use App\Floor;
use App\Http\Controllers\Controller;
use App\Http\Requests\MallSoftware\UnitDefinitions\UnitDefinitionStoreRequest;
use App\Http\Requests\MallSoftware\UnitDefinitions\UnitDefinitionUpdateRequest;
use App\Project;
use App\UnitDefinition;
use App\UnitType;
use Illuminate\Http\Request;
use Yajra\DataTables\DataTables;

class UnitDefinitionManagementController extends Controller
{

    public function index()
    {
        return view('mall_software.unit_definitions.index');
    }

    public function getList()
    {
        $definitions = UnitDefinition::with('getProjects', 'getFloors', 'getTypes')->get();
        return DataTables::of($definitions)
            ->addIndexColumn()
            ->addColumn('projects', function ($definitions) {
                return $definitions->getProjects->project_name;
            })
            ->addColumn('block', function ($definitions) {
                return $definitions->getBlocks->block_name;
            })
            ->addColumn('types', function ($definitions) {
                return $definitions->getTypes->type;
            })
            ->addColumn('floors', function ($definitions) {
                return $definitions->getFloors->name;
            })
            ->addColumn('actions', function ($definitions) {
                $csrfField = csrf_field();
                $deleteRoute = route('mall-software.unit_definitions.destroy', $definitions->id);
                $editbtn = "<a href='" . route("mall-software.unit_definitions.edit", $definitions->id) . "' class='btn'>Edit</a>";
                $deletebtn = <<<HTML
                <form action="{$deleteRoute}" method="post" style ="display:inline">
                {$csrfField}
                <button type="submit" class="btn"><i class='fas fa-trash'></i></button>
                </form>
                HTML;
                return $editbtn . " " . $deletebtn;
            })
            ->removeColumn('id', 'created_at', 'updated_at')
            ->rawColumns(['actions', 'projects', 'floors', 'types', 'block'])
            ->toJson();
    }
    public function create()
    {
        $floors = Floor::get();
        $types = UnitType::get();
        $projects = Project::get();
        $blocks = Block::get();
        return view('mall_software.unit_definitions.create', compact('types', 'floors', 'projects', 'blocks'));
    }

    public function store(UnitDefinitionStoreRequest $request, UnitDefinitionStoreAction $action)
    {
        try {
            $response = $action->execute(collect($request->validated()));
            if ($response) {
                return redirect()->route('mall-software.unit_definitions.index')->with('success', 'Successfully Created');
            } else {
                return redirect()->back()->with(['error' => 'Something went wrong']);
            }
        } catch (\Throwable $th) {
            info($th);
            return redirect()->back()->with(['error' => 'Something went wrong']);
        }
    }


    public function edit(UnitDefinition $unitDefinition)
    {
        $floors = Floor::get();
        $types = UnitType::get();
        $projects = Project::get();
        $blocks = Block::get();
        return view('mall_software.unit_definitions.edit', compact('types', 'floors', 'projects', 'unitDefinition', 'blocks'));
    }

    public function update(UnitDefinitionUpdateRequest $request, UnitDefinitionUpdateAction $action, UnitDefinition $unitDefinition)
    {
        try {
            $response = $action->execute(collect($request->validated()), $unitDefinition);
            if ($response) {
                return redirect()->route('mall-software.unit_definitions.index')->with('success', 'Successfully Updated');
            } else {
                return redirect()->back()->with(['error' => 'Something went wrong']);
            }
        } catch (\Throwable $th) {
            info($th);
            return redirect()->back()->with(['error' => 'Something went wrong']);
        }
    }

    public function destroy(UnitDefinition $unitDefinition)
    {
        try {
            $unitDefinition->delete();
            return redirect()->route('mall-software.unit_definitions.index')->with('success', 'Successfully Deleted');
        } catch (\Throwable $th) {
            info($th);
            return redirect()->back()->with('error', 'Something went wrong, Please try again!');
        }
    }
}
