<?php

namespace App\Http\Controllers\MallSoftware;

use App\Http\Controllers\Controller;
use App\UnitType;
use Illuminate\Http\Request;
use Yajra\DataTables\DataTables;

class UnitTypeManagementController extends Controller
{
    public function index()
    {
        return view('mall_software.unit_type_management.index');
    }

    public function getList()
    {
        $types = UnitType::get();
        return DataTables::of($types)
            ->addIndexColumn()
            ->addColumn('actions', function ($types) {
                $csrfField = csrf_field();
                $deleteRoute = route('mall-software.unit_type_management.destroy', $types->id);
                $editbtn = "<a href='" . route("mall-software.unit_type_management.edit", $types->id) . "' class='btn'>Edit</a>";
                $deletebtn = <<<HTML
                <form action="{$deleteRoute}" method="post" style ="display:inline">
                {$csrfField}
                <button type="submit" class="btn"><i class='fas fa-trash'></i></button>
                </form>
                HTML;
                return $editbtn . " " . $deletebtn;
            })
            ->removeColumn('id', 'created_at', 'updated_at')
            ->rawColumns(['actions'])
            ->toJson();
    }

    public function create()
    {
        return view('mall_software.unit_type_management.create');
    }

    public function store(Request $request)
    {
        $rules = [
            'type' => 'required|string',
            'area' => 'required|numeric',
        ];

        $validatedData = $request->validate($rules);

        $data = new UnitType();
        $data->type = $validatedData['type'];
        $data->area = $validatedData['area'];
        $data->save();
        return redirect()->route('mall-software.unit_type_management.index')->with('success', 'Successfully Created');
        ;
    }

    public function edit(UnitType $types)
    {
        return view('mall_software.unit_type_management.edit', compact('types'));
    }

    public function update(Request $request, UnitType $types)
    {
        $rules = [
            'type' => 'required|string',
            'area' => 'required|numeric',
        ];

        $validatedData = $request->validate($rules);

        $types->type = $validatedData['type'];
        $types->area = $validatedData['area'];
        $types->save();
        return redirect()->route('mall-software.unit_type_management.index')->with('success', 'Successfully Updated');
    }

    public function destroy(UnitType $types)
    {
        try {
            $types->delete();
            return redirect()->route('mall-software.unit_type_management.index')->with('success', 'Successfully Deleted');
        } catch (\Throwable $th) {
            info($th);
            return redirect()->back()->with('error', 'Something went wrong, Please try again!');
        }
    }
}
