<?php

namespace App\Http\Controllers\MallSoftware;

use App\Actions\MallSoftware\Users\UserStoreAction;
use App\Actions\MallSoftware\Users\UserUpdateAction;
use App\Http\Controllers\Controller;
use App\Http\Requests\MallSoftware\Users\UserUpdateRequest;
use App\User;
use App\Role;
use App\Branch;
use App\Http\Requests\MallSoftware\Users\UserStoreRequest;
use Yajra\DataTables\DataTables;

class UserController extends Controller
{
    public function index()
    {
        return view('mall_software.settings.users.index');
    }

    public function getUsersList()
    {
        $users = User::with('getBranch')->get();
        return DataTables::of($users)
            ->addIndexColumn()
            // ->addColumn('branch_name', function ($users) {
            //     return $users->getBranch->name;
            // })
            ->addColumn('status', function ($users) {
                return $users->status == 1 ? 'Active' : 'Un Active';
            })
            ->addColumn('image', function ($users) {
                return $users->image ? $users->image : "";
            })
            ->addColumn('actions', function ($users) {
                $btn = "<a href='" . route("mall-software.users.edit", $users->id) . "' class='btn'>Update</a>";
                return $btn;
            })
            ->removeColumn('id', 'created_at', 'updated_at')
            ->rawColumns(['actions'])
            ->toJson();
    }

    public function create(User $user)
    {
        $reporting_to = User::where('status', 1)->get();
        $roles = Role::where('id', '<>', 1)->get(); //Exclude super admin
        $branches = Branch::where('is_active', 1)->get();
        return view('mall_software.settings.users.create', compact('reporting_to', 'roles', 'branches'));
    }
    public function store(UserStoreRequest $request, UserStoreAction $action)
    {
        try {
            $response = $action->execute(collect($request->validated()));
            if (!$response) {
                return redirect()->back()->with(['error' => 'Something went wrong']);
            } else {
                return redirect()->back()->with(['success' => "User Created successfully"]);
            }

        } catch (\Throwable $th) {
            dd($th);
            info($th);
            return redirect()->back()->with(['error' => 'Something went wrong']);
        }
    }

    public function edit(User $user)
    {
        $reporting_to = User::where('status', 1)->get();
        $roles = Role::where('id', '<>', 1)->get(); //Exclude super admin
        $branches = Branch::where('is_active', 1)->get();
        return view('mall_software.settings.users.edit', compact('user', 'reporting_to', 'roles', 'branches'));
    }

    public function update(UserUpdateRequest $request, UserUpdateAction $action, User $user)
    {
        try {
            $response = $action->execute(collect($request->validated()), $user);
            if (!$response) {
                return redirect()->back()->with(['error' => 'Something went wrong']);
            } else {
                return redirect()->back()->with(['success' => "User details updated successfully"]);
            }

        } catch (\Throwable $th) {
            dd($th);
            info($th);
            return redirect()->back()->with(['error' => 'Something went wrong']);
        }
    }

}
