<?php

namespace App\Http\Middleware;

use Closure;

class RoleMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param $request
     * @param $role
     * @param null $permission
     *
     * @return mixed
     */
    public function handle($request, Closure $next, $role = null, $permission = null)
    {
        // dump($role);
        // dump($permission);
        if (!empty($role)) {
            if (!auth()->user()->hasRole($role)) {
                abort(404);
            }
        }
        // if($permission !== null && !auth()->user()->can($permission)) {
        //     abort(404);
        // }
        if ($permission !== null && !auth()->user()->can($permission)) {
            abort(404);
        }

        return $next($request);
    }
}
