<?php

namespace App\Http\Requests\Api\Enquiry;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class EnquiryRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        return [
            'first_name' => [
                'required',
                'string'
            ],
            'last_name' => [
                'nullable',
                'string'
            ],
            'phone' => [
                'required', 'min:8'
            ],
            'email' => [
                'nullable',
                'email'
            ],
            'convenient_day' => [
                'nullable',
                Rule::in(['Weekdays', 'Weekend'])
            ],
            'convenient_time' => [
                'nullable',
                'required_with:convenient_day',
                Rule::in([
                    'Morning',
                    'Afternoon',
                    'Forenoon',
                    'Evening'
                ])
            ],
            'message' => [
                'nullable',
                'string'
            ]
        ];
    }
}
