<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class ApplicationRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        return [
            'name' => ['required'],
            'dob' => ['nullable'],
            'occupation' => ['nullable'],
            'guardian_name' => ['nullable'],
            'address' => ['required'],
            'pin' => ['required', 'min:6', 'max:6'],
            'village' => ['required'],
            'desom' => ['required'],
            'email' => ['required'],
            'taluk' => ['required'],
            'present_address' => ['nullable'],
            'present_pincode' => ['nullable', 'min:6', 'max:6'],
            'mobile' => ['required', 'numeric', 'min:8'],
            'alt_mobile' => ['nullable'],
            'pancard' => ['required'],
            'project_id' => ['required'],
            'no_of_shares' => ['required'],
            'additional_shares' => ['nullable'],
            'beneficiary_name' => ['nullable'],
            'bank_account_number' => ['nullable'],
            'beneficiary_bank_name' => ['nullable'],
            'beneficiary_branch' => ['nullable'],
            'ifsc_code' => ['nullable'],
            'lead_id' => ['nullable'],
            'proposel_id' => ['nullable'],
            'project_id' => ['nullable'],
            'project_type' => ['nullable'],
            'mode_of_payment' => ['required'],
            'amount' => ['required'],
            'payment_file' => ['required', 'mimes:jpg,jpeg,png,pdf,doc,docx'],
            'bank' => ['required_unless:mode_of_payment,UPI'],
            'cheque_no' => ['required_if:mode_of_payment,Cheque'],
            'cheque_date' => ['required_if:mode_of_payment,Cheque'],
            'cheque_submit_date' => ['required_if:mode_of_payment,Cheque'],
            'fund_transfer_date' => ['required_if:mode_of_payment,EFT'],
            'transaction_ref_no' => ['required_if:mode_of_payment,EFT,UPI'],
            'dd_no' => ['required_if:mode_of_payment,DD'],
            'dd_date' => ['required_if:mode_of_payment,DD'],
            'upi_paid_date' => ['required_if:mode_of_payment,UPI'],
            'upi_provider' => ['required_if:mode_of_payment,UPI'],
        ];
    }
}
