<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class ClientDocumentsUploadRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'customer_img' => 'nullable|mimes:png,jpg,jpeg|max:1024',
            'pan_card' => 'nullable|mimes:png,jpg,jpeg,pdf,docx|max:1024',
            'aadhar_card' => 'nullable|mimes:png,jpg,jpeg,pdf,docx|max:1024',
            'document1' => 'nullable|mimes:png,jpg,jpeg,pdf,docx|max:1024',
            'document2' => 'nullable|mimes:png,jpg,jpeg,pdf,docx|max:1024',
            // 'document3' => 'nullable|mimes:png,jpg,jpeg,pdf,docx|max:1024',
        ];
    }
}
