<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class CommercialProposalRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        return [
            'lead_id' => ['required'],
            'proposal_unit_id' => ['required'],
            'preffered_project' => ['required'],
            'proposal_unit_id' => ['nullable'],
            'kseb_charge' => ['nullable'],
            'cess' => ['nullable'],
            'valuation_fee' => ['nullable'],
            'registration_expense' => ['nullable'],
            'legal' => ['nullable'],
            'monthly_rental' => ['nullable'],
            'type' => ['nullable'],
            'appartment_floor' => ['nullable'],
            'apartment_type' => ['nullable'],
            'no_rooms' => ['nullable'],
            'area_apartment' => ['nullable'],
            'carpet_area' => ['nullable'],
            'cost_apartment' => ['nullable'],
            'grand_total' => ['nullable'],
            'association_deposit' => ['nullable'],
            'on_booking_grand_total' => ['nullable'],
            'on_agreement_grand_total' => ['nullable'],
            'balance' => ['nullable'],
            'amount_received' => ['nullable'],
            'pref_name' => ['required'],
            'name' => ['required'],
            "email" => ['nullable', 'required_without:phone', 'email'],
            "phone" => ['nullable', 'required_without:email', 'min:8'],


        ];
    }
}
