<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class CommercialRequest extends FormRequest
{
    public function authorize()
    {
        return true;
    }

    public function rules()
    {
        return [
            'name' => ['required'],
            'pref_name' => ['required'],
            "email" => ['nullable', 'required_without:phone', 'email'],
            "phone" => ['nullable', 'required_without:email', 'min:8'],
            'preferred_project' => ['required'],
            'share_price' => ['required'],
            'administration_cost' => ['required'],
            'project_monthly_return' => ['required'],
            'option_1' => ['required', 'integer'],
            'option_2' => ['required', 'integer'],
            'option_3' => ['required', 'integer'],
            // 'individual_income' => ['required'],
            // 'grand_total' => ['required'],
            // 'annual_return' => ['required'],
            'project_id' => ['nullable'],
            'project_type' => ['nullable'],
            // 'net_monthly_return' => ['required'],
            'lead_id' => ['nullable'],
        ];
    }
}
