<?php

namespace App\Http\Requests\Dashboard\DailyActivity;

use Illuminate\Foundation\Http\FormRequest;

class DailyActivityStoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [

            'lead_id' => [
                'nullable',
            ],
            'create_task_id' => [
                'required',
            ],
            'lead_category' => [
                'nullable',
            ],
            'project' => [
                'nullable',
            ],
            'lead_stage' => [
                'nullable',
            ],
            'latitude' => [
                'nullable',
            ],
            'longitude' => [
                'nullable',
            ],
            'place_address' => [
                'nullable',
            ],
            'remarks' => [
                'nullable',
            ],
            'image' => [
                'nullable',
            ],
            'city' => [
                'nullable'
            ],
            'location_id' => [
                'nullable'
            ],
            'residential_status' => [
                'nullable'
            ],
            'source' => [
                'nullable'
            ],
            'mobile' => [
                'nullable'
            ],
            'name' => [
                'nullable'
            ],
            'phone_code' => [
                'nullable'
            ],
            'country' => [
                'nullable'
            ],
            'user_id' => (auth()->user()->hasRole('team-leader')) ? 'required' : '',

        ];
    }
}
