<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class InvestmentRequest extends FormRequest
{

    public function authorize()
    {
        return true;
    }


    public function rules()
    {
        return [
            'name' => ['required'],
            'pref_name' => ['required'],
            "email" => ['nullable', 'required_without:phone', 'email'],
            "phone" => ['nullable', 'required_without:email', 'min:8'],
            'preferred_project' => ['required'],
            'project_type'=>['nullable'],
            'cost_apartment' => ['required'],
            'floor' => ['required'],
            'car_parking' => ['nullable'],
            'sba' => ['required'],
            'amount_received' => ['nullable', 'numeric'],
            'type_apartment' => ['required'],
            'balance' => ['nullable'],
            'grand_total' => ['required'],
            'project_id' => ['nullable'],
            'lead_id' => ['nullable'],
            'extended_balcony_area'=>['nullable'],
            'unit_id' =>['nullable'],
            'location'=>['nullable'],
            'parking_number' =>['nullable']
            // 'sba_fixed'=>['nullable']
        ];
    }
}
