<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class InvestmentUpdateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'name' => ['required'],
            'pref_name' => ['required'],
            "email" => ['nullable', 'required_without:phone', 'email'],
            "phone" => ['nullable', 'required_without:email', 'min:8'],
            'preferred_project' => ['required'],
            'cost_apartment' => ['required'],
            'floor' => ['required'],
            'car_parking' => ['nullable'],
            'sba' => ['required'],
            'amount_received' => ['nullable', 'numeric'],
            'type_apartment' => ['required'],
            'balance' => ['nullable'],
            'grand_total' => ['required'],
            'project_id' => ['nullable'],
            'lead_id' => ['nullable'],
        ];
    }
}
