<?php

namespace App\Http\Requests\MallSoftware\Company;

use Illuminate\Foundation\Http\FormRequest;

class CreateCompanyRequest extends FormRequest
{

    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'title' => ['required', 'unique:companies,title'],
            'short_name' => ['required', 'unique:companies,short_name'],
            'phone' => ['required', 'numeric', 'min:10'],
            'email' => ['required','email'],
            'address' => ['nullable'],
            'pincode' => ['nullable','numeric'],
            'country_id' => ['nullable'],
            'state_id' => ['nullable'],
            'web_site' => ['nullable'],
            'location' => ['nullable'],
            'pan_no' => ['nullable'],
            'tan' => ['nullable'],
            'gst_in' => ['nullable'],
            'pf_no' => ['nullable'],
            'cin' => ['nullable'],
            'contact_person' => ['nullable'],
            'contact_phone' => ['nullable','digits:10'],
            'parent_company_id' => ['nullable'],
        ];
    }
}
