<?php

namespace App\Http\Requests\MallSoftware\LeaseRentalAgreement;

use Illuminate\Foundation\Http\FormRequest;

class LeaseRentalAgreementStoreRequest extends FormRequest
{

    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'agreement_no' => 'required',
            'project' => 'required',
            'project_unit' => 'required',
            'floor' => 'required',
            'type' => 'required',
            'type_area' => 'required|numeric',
            'lessee' => 'required',
            'agreement_date' => 'required',
            'agreement_period_from' => 'required',
            'agreement_period_to' => 'required',
            'registration_charges' => 'required|numeric',
            'notice_period' => 'required|numeric',
            'rent_start_date' => 'required',

            // Security Deposit Requests
            'security_deposit_select' => 'nullable',
            'SD_rate_definition_id' => 'nullable',
            'SD_calculation_method' => 'nullable',
            'SD_area_input' => 'nullable',
            'SD_rate' => 'nullable',
            'SD_total_amount' => 'nullable',
            'SD_gst_rate' => 'nullable',
            'SD_gst_amount' => 'nullable',
            'SD_tds_rate' => 'nullable',
            'SD_tds_amount' => 'nullable',
            'SD_net_amount' => 'nullable',

            // Fixed Charges Requests
            'fixed_charges_select' => 'nullable',
            'FC_rate_definition_id' => 'nullable',
            'FC_calculation_method' => 'nullable',
            'FC_area_input' => 'nullable',
            'FC_rate' => 'nullable',
            'FC_total_amount' => 'nullable',
            'FC_gst_rate' => 'nullable',
            'FC_gst_amount' => 'nullable',
            'FC_tds_rate' => 'nullable',
            'FC_tds_amount' => 'nullable',
            'FC_net_amount' => 'nullable',

            // Variable Charges requests
            'variable_charges_select' => 'nullable',
            'VC_rate_definition_id' => 'nullable',
            'VC_rate' => 'nullable',
        ];
    }
}
