<?php

namespace App\Http\Requests\MallSoftware\LesseeEntry;

use Illuminate\Foundation\Http\FormRequest;

class LesseeEntryCompanyUpdateRequest extends FormRequest
{

    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'lessee_entry_type' => 'required',
            'company_name' => 'nullable',
            'date_of_incorporation' => 'nullable',
            'company_contact' => 'nullable|numeric',
            'company_nationality' => 'nullable',
            'company_pan_number' => 'nullable',
            'company_gst_number' => 'nullable',
            'company_permanent_address' => 'nullable',
            'company_paddress_country' => 'nullable',
            'company_paddress_state' => 'nullable',
            'company_paddress_district' => ['required_if:company_paddress_country,101'],
            'company_paddress_pincode' => 'nullable|numeric',
            'company_communication_address' => 'nullable',
            'company_caddress_country' => 'nullable',
            'company_caddress_state' => 'nullable',
            'company_caddress_district' => 'nullable',
            'company_caddress_pincode' => 'nullable|numeric',
            'company_checkbox' => 'nullable',
        ];
    }
}
