<?php

namespace App\Http\Requests\MallSoftware\LesseeEntry;

use Illuminate\Foundation\Http\FormRequest;

class LesseeEntryIndividualUpdateRequest extends FormRequest
{

    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'lessee_entry_type' => 'required',
            'name' => 'nullable',
            'date_of_birth' => 'nullable',
            'individual_contact' => 'nullable|numeric',
            'fathers_name' => 'nullable',
            'individual_nationality' => 'nullable',
            'aadhar_number' => 'nullable|numeric',
            'pan_number' => 'nullable',
            'gstin' => 'nullable',
            'individual_permanent_address' => 'nullable',
            'individual_paddress_country' => 'nullable',
            'individual_paddress_state' => 'nullable',
            'individual_paddress_district' => ['required_if:individual_paddress_country,101'],
            'individual_paddress_pincode' => 'nullable|numeric',
            'individual_communication_address' => 'nullable',
            'individual_caddress_country' => 'nullable',
            'individual_caddress_state' => 'nullable',
            'individual_caddress_district' => 'nullable',
            'individual_caddress_pincode' => 'nullable|numeric',
            'individual_checkbox' => 'nullable',
        ];
    }
}
