<?php

namespace App\Http\Requests\MallSoftware\LesseeEntry;

use Illuminate\Foundation\Http\FormRequest;

class LesseeEntryStoreRequest extends FormRequest
{

    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        // dd('request');
        return [
            'lessee_entry_type' => 'required',

            'name' => 'required_if:lessee_entry_type,Individual',
            'date_of_birth' => 'required_if:lessee_entry_type,Individual',
            'individual_contact' => 'required_if:lessee_entry_type,Individual|numeric',
            'fathers_name' => 'required_if:lessee_entry_type,Individual',
            'individual_nationality' => 'required_if:lessee_entry_type,Individual',
            'aadhar_number' => 'nullable|numeric',
            'pan_number' => 'required_if:lessee_entry_type,Individual',
            'gstin' => 'nullable',
            'individual_permanent_address' => 'required_if:lessee_entry_type,Individual',
            'individual_paddress_country' => 'required_if:lessee_entry_type,Individual',
            'individual_paddress_state' => 'required_if:lessee_entry_type,Individual',
            'individual_paddress_district' => ['required_if:individual_paddress_country,101'],
            'individual_paddress_pincode' => 'required_if:lessee_entry_type,Individual|numeric',
            'individual_communication_address' => 'nullable',
            'individual_caddress_country' => 'nullable',
            'individual_caddress_state' => 'nullable',
            'individual_caddress_district' => 'nullable',
            'individual_caddress_pincode' => 'nullable|numeric',
            'individual_checkbox' => 'nullable',

            'company_name' => 'required_if:lessee_entry_type,Company',
            'date_of_incorporation' => 'required_if:lessee_entry_type,Company',
            'company_contact' => 'required_if:lessee_entry_type,Company|numeric',
            'company_nationality' => 'required_if:lessee_entry_type,Company',
            'company_pan_number' => 'required_if:lessee_entry_type,Company',
            'company_gst_number' => 'nullable',
            'company_permanent_address' => 'required_if:lessee_entry_type,Company',
            'company_paddress_country' => 'required_if:lessee_entry_type,Company',
            'company_paddress_state' => 'required_if:lessee_entry_type,Company',
            'company_paddress_district' => ['required_if:company_paddress_country,101'],
            'company_paddress_pincode' => 'required_if:lessee_entry_type,Company|numeric',
            'company_communication_address' => 'nullable',
            'company_caddress_country' => 'nullable',
            'company_caddress_state' => 'nullable',
            'company_caddress_district' => 'nullable',
            'company_caddress_pincode' => 'nullable|numeric',
            'company_checkbox' => 'nullable',

        ];
    }
}
