<?php

namespace App\Http\Requests\MallSoftware\RateItemDefinition;

use Illuminate\Foundation\Http\FormRequest;

class RateItemDefinitionStoreRequest extends FormRequest
{

    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        // dd('request');
        return [
            'rate_type' => 'required',
            'rate_item_name' => 'required',
            'rate_calculation_method' => 'required',
            'default_rate' => 'nullable|numeric',
            'remarks' => 'nullable',
            'gst_percentage' => 'nullable',
            'tds_percentage' => 'nullable',
            'other_taxes' => 'nullable',
            'due_days' => 'required',
            'active' => 'nullable',
            'hsn-sac-code' => 'nullable',
            'group_select' => 'required',
            'individual_ledger' => 'required',
            'prefix' => 'nullable|alpha',
            'financial_year' => 'nullable',
            'next_number' => 'nullable|numeric',
            'reset_number' => 'nullable|numeric',

        ];
    }
}
