<?php
namespace App\Http\Requests\MallSoftware\Users;

use Illuminate\Foundation\Http\FormRequest;

class UserStoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'name' => ['required'],
            'full_name' => ['required'],
            'username' => ['required'],
            'email' => ['required', 'unique:users'],
            'password' => ['required'],
            'confirm_password' => ['required', 'same:password'],
            'mobile' => ['required'],
            'designation' => ['required'],
            'blood_group' => ['required'],
            'address' => ['required'],
            'date_of_birth' => ['required'],
            'gender' => ['required'],
        ];
    }
}
