<?php
namespace App\Http\Requests\MallSoftware\Users;

use Illuminate\Foundation\Http\FormRequest;

class UserUpdateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'name' => ['required'],
            'full_name' => ['required'],
            'username' => ['required'],
            'email' => 'nullable|unique:users,email,' . $this->id,
            'password' => ['nullable'],
            'confirm_password' => ['nullable', 'same:password'],
            'mobile' => ['required'],
            'designation' => ['required'],
            'blood_group' => ['required'],
            'address' => ['required'],
            'date_of_birth' => ['required'],
            'gender' => ['required'],
        ];
    }
}
