<?php

namespace App\Http\Requests\PreferredProject;

use Illuminate\Foundation\Http\FormRequest;

class DocumentUpdateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'project_id' => ['required'],
            'file' => ['required', 'mimes:jpg,jpeg,png,pdf,doc,docx,txt'],

            'ebrochure' => ['nullable'],
            'term_sheet' => ['nullable'],
            'progress_report' => ['nullable'],
            'availability_chart' => ['nullable'],
            'mou' => ['nullable'],
            'sample_calculation' => ['nullable'],
            'allotment_letter' => ['nullable'],
            'home_page_image' => ['nullable'],
            'project_logo' => ['nullable'],

        ];
    }
}
