<?php

namespace App\Http\Requests\PreferredProject;

use Illuminate\Foundation\Http\FormRequest;

class MailRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'to' => ['required', 'email'],
            'message' => ['required'],
            'project_id' => ['required'],




            'cc' => ['nullable'],
            'bcc' => ['nullable'],
            'mobile' => ['nullable', 'min:8'],
            'include_ebrochure' => ['nullable'],
            'include_walk_through' => ['nullable'],
            'include_mobile_brochure' => ['nullable'],
            'include_term_sheet' => ['nullable'],
            'include_progress_report' => ['nullable'],
            'include_location_map' => ['nullable'],
            'include_availability_chart' => ['nullable'],
            'include_mou' => ['nullable'],
            'include_sample_calculation' => ['nullable'],
            'name' => ['required', 'string', 'max:255'],

            'email_type' => ['nullable'],
        ];
    }
}
