<?php

namespace App\Http\Requests\ProjectUnit;

use Illuminate\Foundation\Http\FormRequest;

class UnitRequest extends FormRequest
{

    public function authorize()
    {
        return true;
    }


    public function rules()
    {
        return [
            'project_id' => ['required'],
            'floor' => ['nullable'],
            'ap_no' => ['required', 'unique:price_list'],
            'sba_area' => ['required'],
            'monthly_rental' =>['required_if:type,rental_commitment'],
            'sale_value' => ['required'],
            'rate_per_sqft' => ['required'],
            'layour_plan' => ['nullable', 'mimes:jpg,jpeg,png'],
            // 'type'=>['required']

        ];
    }
}
