<?php

namespace App\Http\Requests\ProjectUnit;

use Illuminate\Foundation\Http\FormRequest;

class UpdateUnitRequest extends FormRequest
{
  
    public function authorize()
    {
        return true;
    }

   
    public function rules()
    {
        return [
            'id'=>['required'],
            'project_id' => ['required'],
            'floor' => ['nullable'],
            'ap_no' => ['required'],
            'sba_area' => ['required'],
            'monthly_rental' => ['required_if:type,rental_commitment'],
            'sale_value' => ['required'],
            'rate_per_sqft' => ['required'],
            'layout_plan' => ['nullable', 'mimes:jpg,jpeg,png'],
            'type'=>['nullable'],
            'booking_status_id' =>['nullable']
        ];
    }
}
