<?php

namespace App\Http\Requests\Registration;

use Illuminate\Foundation\Http\FormRequest;

class RegistrationRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'project_id' => ['required'],
            'unit_id' => ['required'],
            'name_prefix' => ['required'],
            'name' => ['required'],
            'dob' => ['nullable'],
            'age' => [
                'nullable',
                'required_with:dob', 'max:100'
            ],
            'guardian_name' => ['nullable'],
            'occupation' => ['nullable'],




            'address' => [
                'nullable',
            ],
            'pin' => [
                'nullable',
                'min:6',
                'max:6'
            ],



            'amsom' => ['nullable'],
            'desom' => ['nullable'],
            'village' => ['nullable'],
            'taluk' => ['nullable'],
            'district' => ['nullable'],
            'present_address' => [
                'nullable',
                'required_with:present_pincode'
            ],
            'present_pincode' => [
                'nullable',
                'required_with:present_address',
                'min:6',
                'max:6'
            ],
            'pancard' => ['nullable'],
            'phone_no' => ['nullable'],
            'phone_code' => ['nullable', 'required_with:mobile'],
            'mobile' => ['nullable', 'min:8', 'max:10'],
            'email' => ['nullable', 'email'],
            'identity_card' => ['nullable'],
            'identity_card_no' => ['nullable'],
            'co_owner_name_prefix' => [
                'nullable',
                'required_with:co_owner_name'
            ],
            'co_owner_name' => [
                'nullable',
                'required_with:co_owner_name_prefix'
            ],
            'co_owner_dob' => ['nullable'],
            'co_owner_age' => [
                'nullable',
                'required_with:co_owner_dob', 'max:100'
            ],
            'co_owner_guardian_name' => ['nullable'],
            'co_owner_occupation' => ['nullable'],
            'co_owner_address' => [
                'nullable',
                'required_with:co_owner_pin'
            ],
            'co_owner_pin' => [
                'nullable',
                'required_with:co_owner_address',
                'min:6',
                'max:6'
            ],
            'co_owner_amsom' => ['nullable'],
            'co_owner_desom' => ['nullable'],
            'co_owner_village' => ['nullable'],
            'co_owner_taluk' => ['nullable'],
            'co_owner_district' => ['nullable'],
            'co_owner_present_address' => [
                'nullable',
                'required_with:co_owner_present_pincode'
            ],
            'co_owner_present_pincode' => [
                'nullable',
                'required_with:co_owner_present_address'
            ],
            'co_owner_pancard' => ['nullable'],

            'co_owner_phone_code' => ['nullable', 'required_with:co_owner_mobile'],

            'co_owner_mobile' => [
                'nullable',
                'min:6',
                'max:10'
            ],
            'co_owner_email' => ['nullable', 'email'],
            'co_owner_identity_card' => [
                'nullable',
                'required_with:co_owner_identity_card_no'
            ],
            'co_owner_identity_card_no' => [
                'nullable',
                'required_with:co_owner_identity_card'
            ],
            'contact_person_name_prefix' => [
                'nullable',
                'required_with:contact_person_name'
            ],
            'contact_person_name' => [
                'nullable',
                'required_with:contact_person_name_prefix'
            ],
            'contact_person_phone_code' => ['nullable', 'required_with:contact_person_mobile'],
            'contact_person_mobile' => ['nullable', 'min:6', 'max:10'],
            'contact_person_address' => [
                'nullable',
                'required_with:contact_person_pincode',
            ],
            'contact_person_pincode' => [
                'nullable',
                'required_with:contact_person_address',
                'min:6',
                'max:6'
            ],
        ];
    }
}
