<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UpdateSalesQuarterRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'sale_quarter_id' => ['required'],
            'user_id' => ['required'],
            'month' => ['required_with:monthly_target'],
            'monthly_target' => ['required_with:month'],
            'quarterly_dates' => ['required'],
            'quarterly_target' => ['required'],
            'sales_quarter_name' => ['nullable'],
            'my_target' => ['nullable'],
        ];
    }
}
