<?php

namespace App\Http\Requests\User;

use App\Rules\MatchOldPassword;
use Illuminate\Foundation\Http\FormRequest;

class PasswordUpdateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            // 'user_id' => ['required'],
            'current_password' => ['required_with_all:new_password,new_confirm_password', new MatchOldPassword],
            'new_password' => ['required_with:current_password'],
            'new_confirm_password' => ['required_with:new_password', 'same:new_password'],
        ];
    }
}
