<?php

namespace App\Http\Requests\User;

use App\Rules\MatchOldPassword;
use Illuminate\Foundation\Http\FormRequest;

class ProfileUpdateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'user_id' => ['required'],
            'name' => ['required'],
            'username' => ['required'],

            'designation' => ['nullable'],
            'phone_code' => ['required_with:mobile'],
            'mobile' => ['nullable', 'min:8'],

            // 'current_password' => ['required_with:new_password', new MatchOldPassword],
            // 'new_password' => ['required_with:current_password', 'min:8'],
            // 'new_confirm_password' => ['required_with:new_password', 'confirmed'],



            'image' => ['nullable', 'mimes:jpg,jpeg,png', 'dimensions:min_width=200,min_height=200,max_width=250,max_height=250'],

            'email' => ['nullable', 'email'],
            'gmail_password' => ['nullable']
        ];
    }
}
