<?php

namespace App\Imports;

use App\ContactList;
use Illuminate\Validation\Rule;
use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Validators\Failure;
use Maatwebsite\Excel\Concerns\ToCollection;
use Maatwebsite\Excel\Concerns\WithStartRow;
use Maatwebsite\Excel\Concerns\WithValidation;

class ContactsListImport implements ToModel, WithStartRow, WithValidation
{

    public function model(array $row)
    {


        ContactList::updateOrCreate(
            ['email' => $row[1], 'contact_group_id' => $row[2]],

            [
                'name' => $row[0],

                'email' => $row[1],

                'contact_group_id' => $row[2],

                'phone_code' => $row[3],

                'phone' => $row[4],

                'interested_project' => $row[5],

                'imported_by' => auth()->user()->id,

            ]
        );
    }


    public function startRow(): int
    {
        return 2;
    }

    public function rules(): array
    {
        return [
            '0' => ['required'],
            // '1' => ['required', 'email', 'unique:contact_lists,email'],
            '1' => [
                'required', 'email'
            ],

            '2' => ['required', 'exists:contact_groups,id'],
            '3' => ['nullable', 'required_with:*.4'],
            '4' => ['nullable'],
            '5' => ['nullable'],





        ];
    }
    public function customValidationMessages()
    {
        return [
            '0.required' => 'Name field is required.',
            '1.required' => 'Email field is required and must be a valid email.',
            '2.required' => 'Contact group field is required.',
            '3.required_with' => 'Phone code is required when phone number is present.',

            // '1.unique' => 'Email id already exists',


        ];
    }
    public function onFailure(Failure ...$failures)
    {
        // Handle the failures how you'd like.
    }

    public function onError(\Throwable $e)
    {
        // Handle the exception how you'd like.
        throw $e;
    }
}
